/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.mem;

import java.lang.ref.Cleaner;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class GrabAllocator
implements MemoryAllocator {
    private static final long BASE_GRAB_SIZE = ByteUnit.kibiBytes(512L);
    private static final long MAX_GRAB_SIZE = ByteUnit.gibiBytes(1L);
    private static final long BASE_MEMORY_SIZE = ByteUnit.gibiBytes(100L);
    private static final Cleaner globalCleaner = GrabAllocator.globalCleaner();
    private final Grabs grabs;
    private final Cleaner.Cleanable cleanable;

    GrabAllocator(long expectedMaxMemory, Long grabSize, MemoryTracker memoryTracker) {
        Preconditions.requirePositive((long)expectedMaxMemory);
        this.grabs = new Grabs(expectedMaxMemory, GrabAllocator.calculateGrabSize(grabSize, expectedMaxMemory), memoryTracker);
        this.cleanable = globalCleaner.register(this, new GrabsDeallocator(this.grabs));
    }

    static long calculateGrabSize(Long grabSize, long expectedMaxMemory) {
        if (grabSize != null) {
            Preconditions.requirePositive((long)grabSize);
            return grabSize;
        }
        return Math.min(BASE_GRAB_SIZE + expectedMaxMemory / BASE_MEMORY_SIZE * BASE_GRAB_SIZE, MAX_GRAB_SIZE);
    }

    @Override
    public synchronized long usedMemory() {
        return this.grabs.usedMemory();
    }

    @Override
    public synchronized long availableMemory() {
        return this.grabs.availableMemory();
    }

    @Override
    public synchronized long allocateAligned(long bytes, long alignment) {
        return this.grabs.allocateAligned(bytes, alignment);
    }

    @Override
    public void close() {
        this.cleanable.clean();
    }

    private static Cleaner globalCleaner() {
        return Cleaner.create();
    }

    private static final class Grabs {
        private final long grabSize;
        private final MemoryTracker memoryTracker;
        private long expectedMaxMemory;
        private Grab head;

        Grabs(long expectedMaxMemory, long grabSize, MemoryTracker memoryTracker) {
            this.expectedMaxMemory = expectedMaxMemory;
            this.grabSize = grabSize;
            this.memoryTracker = memoryTracker;
        }

        long usedMemory() {
            long sum = 0L;
            Grab grab = this.head;
            while (grab != null) {
                sum += grab.nextPointer - grab.address;
                grab = grab.next;
            }
            return sum;
        }

        long availableMemory() {
            Grab grab = this.head;
            long availableInCurrentGrab = 0L;
            if (grab != null) {
                availableInCurrentGrab = grab.limit - grab.nextPointer;
            }
            return Math.max(this.expectedMaxMemory, 0L) + availableInCurrentGrab;
        }

        public void close() {
            Grab current = this.head;
            while (current != null) {
                current.free(this.memoryTracker);
                current = current.next;
            }
            this.head = null;
        }

        long allocateAligned(long bytes, long alignment) {
            if (alignment <= 0L) {
                throw new IllegalArgumentException("Invalid alignment: " + alignment + ". Alignment must be positive.");
            }
            long sizeWithAlignment = bytes + alignment - 1L;
            if (sizeWithAlignment > this.grabSize) {
                Grab nextGrab = this.head == null ? null : this.head.next;
                Grab allocationGrab = new Grab(nextGrab, sizeWithAlignment, this.memoryTracker);
                long allocation = allocationGrab.allocate(bytes, alignment);
                this.head = this.head == null ? allocationGrab : this.head.setNext(allocationGrab);
                this.expectedMaxMemory -= sizeWithAlignment;
                return allocation;
            }
            if (this.head == null || !this.head.canAllocate(bytes, alignment)) {
                this.head = new Grab(this.head, this.grabSize, this.memoryTracker);
                this.expectedMaxMemory -= this.grabSize;
            }
            return this.head.allocate(bytes, alignment);
        }
    }

    private static final class GrabsDeallocator
    implements Runnable {
        private final Grabs grabs;

        GrabsDeallocator(Grabs grabs) {
            this.grabs = grabs;
        }

        @Override
        public void run() {
            this.grabs.close();
        }
    }

    private static class Grab {
        public final Grab next;
        private final long address;
        private final long limit;
        private long nextPointer;

        Grab(Grab next, long size, MemoryTracker memoryTracker) {
            this.next = next;
            this.address = UnsafeUtil.allocateMemory((long)size, (MemoryTracker)memoryTracker);
            this.limit = this.address + size;
            this.nextPointer = this.address;
        }

        Grab(Grab next, long address, long limit, long nextPointer) {
            this.next = next;
            this.address = address;
            this.limit = limit;
            this.nextPointer = nextPointer;
        }

        private static long nextAligned(long pointer, long alignment) {
            if (alignment == 1L) {
                return pointer;
            }
            long off = pointer % alignment;
            if (off == 0L) {
                return pointer;
            }
            return pointer + (alignment - off);
        }

        long allocate(long bytes, long alignment) {
            long allocation = Grab.nextAligned(this.nextPointer, alignment);
            this.nextPointer = allocation + bytes;
            return allocation;
        }

        void free(MemoryTracker memoryTracker) {
            UnsafeUtil.free((long)this.address, (long)(this.limit - this.address), (MemoryTracker)memoryTracker);
        }

        boolean canAllocate(long bytes, long alignment) {
            return Grab.nextAligned(this.nextPointer, alignment) + bytes <= this.limit;
        }

        Grab setNext(Grab grab) {
            return new Grab(grab, this.address, this.limit, this.nextPointer);
        }

        public String toString() {
            long size = this.limit - this.address;
            long reserve = this.nextPointer > this.limit ? 0L : this.limit - this.nextPointer;
            double use = (1.0 - (double)reserve / (double)size) * 100.0;
            return String.format("Grab[size = %d bytes, reserve = %d bytes, use = %5.2f %%]", size, reserve, use);
        }
    }
}

