/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.TransactionWork;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.Neo4jDatabaseMetaData;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jConnectionImpl;
import org.neo4j.jdbc.metadata.Column;
import org.neo4j.jdbc.metadata.Table;
import org.neo4j.jdbc.utils.BoltNeo4jUtils;
import org.neo4j.jdbc.utils.Neo4jInvocationHandler;

public class BoltNeo4jDatabaseMetaData
extends Neo4jDatabaseMetaData {
    private static final String DB_PROPERTIES_QUERY = "MATCH (n:`%s`) WITH n LIMIT %d UNWIND keys(n) as key RETURN collect(distinct key) as keys";
    private static final Logger LOGGER = Logger.getLogger(BoltNeo4jDatabaseMetaData.class.getCanonicalName());
    private List<String> functions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoltNeo4jDatabaseMetaData(BoltNeo4jConnectionImpl connection) {
        super((Neo4jConnection)connection);
        if (connection != null) {
            Session session = null;
            try {
                session = connection.newNeo4jSession();
                this.getDatabaseVersion(session);
                this.getDatabaseLabels(session);
                this.getDatabaseProperties(session);
                this.functions = this.callDbmsFunctions(session);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                BoltNeo4jUtils.closeSafely((AutoCloseable)session, LOGGER);
            }
        }
    }

    public static DatabaseMetaData newInstance(boolean debug, BoltNeo4jConnectionImpl connection) {
        BoltNeo4jDatabaseMetaData dbmd = new BoltNeo4jDatabaseMetaData(connection);
        return (DatabaseMetaData)Proxy.newProxyInstance(BoltNeo4jDatabaseMetaData.class.getClassLoader(), new Class[]{DatabaseMetaData.class}, (InvocationHandler)new Neo4jInvocationHandler((Object)dbmd, debug));
    }

    private void getDatabaseVersion(Session session) {
        this.databaseVersion = (String)session.readTransaction(tx -> {
            Result records = tx.run("CALL dbms.components() yield name,versions WITH * WHERE name=\"Neo4j Kernel\" RETURN versions[0] AS version");
            if (!records.hasNext()) {
                return null;
            }
            return records.next().get("version").asString();
        });
    }

    private void getDatabaseLabels(Session session) {
        this.databaseLabels = (List)session.readTransaction(tx -> tx.run("CALL db.labels() YIELD label RETURN label").list(record -> new Table(record.get("label").asString())));
    }

    private void getDatabaseProperties(Session session) {
        if (this.databaseLabels == null) {
            return;
        }
        ArrayList properties = new ArrayList(this.databaseLabels.size() * 3);
        for (Table label : this.databaseLabels) {
            properties.addAll((Collection)session.readTransaction(this.getColumnSample(label.getTableName())));
        }
        this.databaseProperties = properties;
    }

    private TransactionWork<List<Column>> getColumnSample(String label) {
        return tx -> {
            String query = String.format(DB_PROPERTIES_QUERY, label, 1000);
            AtomicInteger keyIndex = new AtomicInteger(0);
            return tx.run(query).stream().flatMap(record -> record.get("keys").asList().stream()).map(key -> new Column(label, (String)key, keyIndex.getAndIncrement())).collect(Collectors.toList());
        };
    }

    private List<String> callDbmsFunctions(Session session) {
        try {
            return (List)session.readTransaction(tx -> {
                ArrayList<String> functions = new ArrayList<String>();
                Result rs = tx.run("CALL dbms.functions() YIELD name RETURN name ORDER BY name ASC");
                while (rs != null && rs.hasNext()) {
                    Record record = rs.next();
                    functions.add(record.get("name").asString());
                }
                return functions;
            });
        }
        catch (Exception e) {
            LOGGER.warning(String.format("Could not retrieve DBMS functions:%n%s", e));
            return Collections.emptyList();
        }
    }

    public String getSystemFunctions() throws SQLException {
        return String.join((CharSequence)",", this.functions);
    }
}

