/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt.cache;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;

public class BoltDriverCacheKey {
    private List<URI> routingUris;
    private Config config;
    private AuthToken authToken;
    private Properties info;

    public BoltDriverCacheKey(List<URI> routingUris, Config config, AuthToken authToken, Properties info) {
        this.routingUris = routingUris;
        this.config = config;
        this.authToken = authToken;
        this.info = info;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoltDriverCacheKey that = (BoltDriverCacheKey)o;
        return Objects.equals(this.routingUris, that.routingUris) && BoltDriverCacheKey.compareConfig(this.config, that.config) && Objects.equals(this.authToken, that.authToken) && Objects.equals(this.info, that.info);
    }

    public List<URI> getRoutingUris() {
        return this.routingUris;
    }

    public Config getConfig() {
        return this.config;
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    public Properties getInfo() {
        return this.info;
    }

    protected static boolean compareConfig(Config o1, Config o2) {
        boolean equal = o1.encrypted() == o2.encrypted();
        equal = equal && o1.idleTimeBeforeConnectionTest() == o2.idleTimeBeforeConnectionTest();
        equal = equal && o1.maxConnectionLifetimeMillis() == o2.maxConnectionLifetimeMillis();
        equal = equal && o1.maxConnectionPoolSize() == o2.maxConnectionPoolSize();
        equal = equal && o1.connectionAcquisitionTimeoutMillis() == o2.connectionAcquisitionTimeoutMillis();
        equal = equal && o1.logLeakedSessions() == o2.logLeakedSessions();
        equal = equal && BoltDriverCacheKey.trustStrategyEquals(o1.trustStrategy(), o2.trustStrategy());
        return equal;
    }

    protected static boolean trustStrategyEquals(Config.TrustStrategy t1, Config.TrustStrategy t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        return Objects.equals(t1.certFile(), t2.certFile()) && t1.strategy() == t2.strategy();
    }
}

