/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.boltrouting;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.jdbc.bolt.DriverFactory;
import org.neo4j.jdbc.bolt.cache.BoltDriverCache;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jDriverImpl;
import org.neo4j.jdbc.utils.BoltNeo4jUtils;

public class BoltRoutingNeo4jDriver
extends BoltNeo4jDriverImpl {
    public static final String JDBC_BOLT_ROUTING_PREFIX = "^neo4j(\\+s|\\+ssc)?$";
    public static final String ROUTING_CONTEXT = "routing";
    public static final String ALTERNATIVE_SERVERS = "servers";
    public static final String BOOKMARK = "bookmark";
    public static final String LIST_SEPARATOR = ";";
    public static final String CUSTOM_ROUTING_POLICY_SEPARATOR = "&";
    private static final BoltDriverCache cache = new BoltDriverCache(params -> {
        for (URI uri : params.getRoutingUris()) {
            Driver driver = GraphDatabase.driver((URI)uri, (AuthToken)params.getAuthToken(), (Config)params.getConfig());
            try {
                driver.verifyConnectivity();
                return driver;
            }
            catch (ServiceUnavailableException e) {}
            continue;
            finally {
                BoltNeo4jUtils.closeSafely((AutoCloseable)driver, null);
            }
        }
        throw new ServiceUnavailableException("Failed to discover an available server");
    });
    private final DriverFactory driverFactory;

    public BoltRoutingNeo4jDriver() throws SQLException {
        this(cache::getDriver);
    }

    public BoltRoutingNeo4jDriver(String prefix) {
        super(prefix);
        this.driverFactory = cache::getDriver;
    }

    BoltRoutingNeo4jDriver(DriverFactory driverFactory) throws SQLException {
        super(JDBC_BOLT_ROUTING_PREFIX);
        this.driverFactory = driverFactory;
    }

    private boolean isSchemaMatchPrefix(String url) {
        URI uri = URI.create(url);
        return uri.getScheme().matches(this.getPrefix());
    }

    @Override
    protected Driver getDriver(List<URI> routingUris, Config config, AuthToken authToken, Properties info) throws URISyntaxException {
        return this.driverFactory.createDriver(routingUris, config, authToken, info);
    }

    @Override
    protected Properties getRoutingContext(String url, Properties properties) {
        if (!this.isSchemaMatchPrefix(url) || !properties.containsKey(ROUTING_CONTEXT)) {
            return new Properties();
        }
        Properties props = new Properties();
        for (String routingParam : this.routingParameters(properties)) {
            if (routingParam.startsWith(ALTERNATIVE_SERVERS)) {
                props.put(ALTERNATIVE_SERVERS, routingParam.substring(ALTERNATIVE_SERVERS.length() + 1));
                continue;
            }
            props.put(ROUTING_CONTEXT, routingParam);
        }
        return props;
    }

    @Override
    protected String addRoutingPolicy(String url, Properties properties) {
        String boltUrl = url;
        if (this.isSchemaMatchPrefix(url) && properties.containsKey(ROUTING_CONTEXT)) {
            boltUrl = boltUrl + "?" + properties.getProperty(ROUTING_CONTEXT).replaceAll(LIST_SEPARATOR, CUSTOM_ROUTING_POLICY_SEPARATOR);
        }
        return boltUrl;
    }

    @Override
    protected List<URI> buildRoutingUris(String boltUrl, Properties properties) throws URISyntaxException {
        String[] servers;
        URI firstServer = new URI(boltUrl);
        ArrayList<URI> routingUris = new ArrayList<URI>();
        for (String server : servers = firstServer.getAuthority().split(",")) {
            routingUris.add(new URI(firstServer.getScheme(), server, firstServer.getPath(), firstServer.getQuery(), firstServer.getFragment()));
        }
        if (properties.containsKey(ALTERNATIVE_SERVERS)) {
            String[] alternativeServerList;
            String alternativeServers = properties.getProperty(ALTERNATIVE_SERVERS);
            for (String alternativeServer : alternativeServerList = alternativeServers.split(LIST_SEPARATOR)) {
                routingUris.add(new URI(firstServer.getScheme(), alternativeServer, firstServer.getPath(), firstServer.getQuery(), firstServer.getFragment()));
            }
        }
        return routingUris;
    }

    private List<String> routingParameters(Properties properties) {
        if (properties.get(ROUTING_CONTEXT) instanceof String) {
            return Collections.singletonList(properties.getProperty(ROUTING_CONTEXT));
        }
        return (List)properties.get(ROUTING_CONTEXT);
    }

    static {
        try {
            BoltRoutingNeo4jDriver driver = new BoltRoutingNeo4jDriver();
            DriverManager.registerDriver((java.sql.Driver)((Object)driver));
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

