/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.utils;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.jdbc.bolt.BoltNeo4jConnection;
import org.neo4j.jdbc.utils.RetryExceptionPredicate;

public class BoltNeo4jUtils {
    public static final RetryConfig RETRY_CONFIG = RetryConfig.custom().retryOnException((Predicate)new RetryExceptionPredicate()).waitDuration(Duration.of(1L, ChronoUnit.SECONDS)).maxAttempts(10).build();

    public static int calculateUpdateCount(SummaryCounters stats) {
        int objectCount = 0;
        objectCount += stats.nodesCreated();
        objectCount += stats.nodesDeleted();
        objectCount += stats.relationshipsCreated();
        objectCount += stats.relationshipsDeleted();
        int schemaCount = 0;
        schemaCount += stats.constraintsAdded();
        schemaCount += stats.constraintsRemoved();
        schemaCount += stats.indexesAdded();
        schemaCount += stats.indexesRemoved();
        schemaCount += stats.labelsAdded();
        int updateCount = objectCount == 0 ? (schemaCount += stats.labelsRemoved()) : objectCount;
        return updateCount == 0 ? stats.propertiesSet() : updateCount;
    }

    public static <R> R executeInTx(BoltNeo4jConnection connection, String sql, Map<String, Object> params, Function<Result, R> body) throws SQLException {
        try {
            Result statementResult = BoltNeo4jUtils.execute(connection, sql, params);
            R result = body.apply(statementResult);
            if (connection.getAutoCommit()) {
                connection.doCommit();
            }
            return result;
        }
        catch (Exception e) {
            connection.doRollback();
            throw new SQLException(e);
        }
    }

    public static <R> R executeInTx(BoltNeo4jConnection connection, String sql, Function<Result, R> body) throws SQLException {
        return BoltNeo4jUtils.executeInTx(connection, sql, Collections.emptyMap(), body);
    }

    private static Result execute(BoltNeo4jConnection connection, String statement, Map<String, Object> params) throws Exception {
        return BoltNeo4jUtils.runTransactionWithRetries(connection.getTransaction(), statement, params);
    }

    public static Result runTransactionWithRetries(Transaction tx, String statement, Map<String, Object> params) throws Exception {
        return (Result)Retry.decorateCallable((Retry)Retry.of((String)"retryPool", (RetryConfig)RETRY_CONFIG), () -> tx.run(statement, params)).call();
    }

    public static void closeSafely(AutoCloseable closeable, Logger logger) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            if (logger == null) {
                return;
            }
            logger.warning("Exception while trying to close an AutoCloseable, because of the following exception: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasResultSet(BoltNeo4jConnection connection, String cypher) {
        if (StringUtils.isBlank((CharSequence)cypher)) {
            return false;
        }
        try (Session session = connection.newNeo4jSession();){
            boolean bl;
            block15: {
                Transaction transaction = session.beginTransaction();
                try {
                    String toUpperCase = cypher.trim().toUpperCase(Locale.ROOT);
                    String cql = toUpperCase.startsWith("EXPLAIN") || toUpperCase.startsWith("PROFILE") ? cypher : "EXPLAIN " + cypher;
                    bl = transaction.run(cql).consume().plan().children().stream().map(f -> f.operatorType()).noneMatch(o -> o.toUpperCase(Locale.ROOT).contains("EMPTYRESULT"));
                    if (transaction == null) break block15;
                }
                catch (Throwable throwable) {
                    if (transaction != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                transaction.close();
            }
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }
}

