/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.utils;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Point;
import org.neo4j.driver.types.Relationship;
import org.neo4j.jdbc.utils.Neo4jJdbcPrettyPrinter;
import org.neo4j.jdbc.utils.NodeSerializer;
import org.neo4j.jdbc.utils.PathSerializer;
import org.neo4j.jdbc.utils.PointSerializer;
import org.neo4j.jdbc.utils.RelationshipSerializer;

public class JSONUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter OBJECT_WRITER;

    public static String writeValueAsString(Object value) {
        try {
            return OBJECT_WRITER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T convertValue(Object value, Class<T> type) {
        try {
            return (T)OBJECT_MAPPER.convertValue(value, type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        SimpleModule module = new SimpleModule("Neo4jJdbcSerializer");
        module.addSerializer(Node.class, (JsonSerializer)new NodeSerializer());
        module.addSerializer(Relationship.class, (JsonSerializer)new RelationshipSerializer());
        module.addSerializer(Path.class, (JsonSerializer)new PathSerializer());
        module.addSerializer(Point.class, (JsonSerializer)new PointSerializer());
        OBJECT_MAPPER.registerModule((Module)module);
        OBJECT_MAPPER.setDefaultPrettyPrinter((PrettyPrinter)new Neo4jJdbcPrettyPrinter());
        OBJECT_WRITER = OBJECT_MAPPER.writerWithDefaultPrettyPrinter();
    }
}

