/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx;

import java.lang.management.ManagementFactory;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.GraphDatabaseAPI;

public class JmxUtils {
    private static final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public static ObjectName getObjectName(GraphDatabaseService db, String name) {
        if (!(db instanceof GraphDatabaseAPI)) {
            throw new IllegalArgumentException("Can only resolve object names for embedded Neo4j database instances, eg. instances created by GraphDatabaseFactory or HighlyAvailableGraphDatabaseFactory.");
        }
        ObjectName neoQuery = ((JmxKernelExtension)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Kernel.class).getMBeanQuery();
        String instance = neoQuery.getKeyProperty("instance");
        String domain = neoQuery.getDomain();
        try {
            return new ObjectName(String.format("%s:instance=%s,name=%s", domain, instance, name));
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getAttribute(ObjectName objectName, String attribute) {
        try {
            return (T)mbeanServer.getAttribute(objectName, attribute);
        }
        catch (MBeanException e) {
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invoke(ObjectName objectName, String attribute, Object[] params, String[] signatur) {
        try {
            return (T)mbeanServer.invoke(objectName, attribute, params, signatur);
        }
        catch (MBeanException e) {
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }
}

