/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.neo4j.graphdb.schema.IndexPopulationProgress;
import org.neo4j.internal.helpers.collection.Pair;

public interface PopulationProgress {
    public static final PopulationProgress NONE = PopulationProgress.single(0L, 0L);
    public static final PopulationProgress DONE = PopulationProgress.single(1L, 1L);

    public long getCompleted();

    public long getTotal();

    public float getProgress();

    public IndexPopulationProgress toIndexPopulationProgress();

    public static PopulationProgress single(final long completed, final long total) {
        return new PopulationProgress(){

            @Override
            public long getCompleted() {
                return completed;
            }

            @Override
            public long getTotal() {
                return total;
            }

            @Override
            public float getProgress() {
                return total == 0L ? 0.0f : (float)((double)completed / (double)total);
            }

            @Override
            public IndexPopulationProgress toIndexPopulationProgress() {
                return new IndexPopulationProgress(completed, total);
            }

            public String toString() {
                return String.format(Locale.ROOT, "[%d/%d:%f]", completed, total, Float.valueOf(this.getProgress()));
            }
        };
    }

    public static MultiBuilder multiple() {
        return new MultiBuilder();
    }

    public static class MultiBuilder {
        private final List<Pair<PopulationProgress, Float>> parts = new ArrayList<Pair<PopulationProgress, Float>>();
        private float totalWeight;

        public MultiBuilder add(PopulationProgress part, float weight) {
            this.parts.add((Pair<PopulationProgress, Float>)Pair.of((Object)part, (Object)Float.valueOf(weight)));
            this.totalWeight += weight;
            return this;
        }

        public PopulationProgress build() {
            final float[] weightFactors = this.buildWeightFactors();
            return new PopulationProgress(){

                @Override
                public long getCompleted() {
                    return parts.stream().mapToLong(part -> ((PopulationProgress)part.first()).getCompleted()).sum();
                }

                @Override
                public long getTotal() {
                    return parts.stream().mapToLong(part -> ((PopulationProgress)part.first()).getTotal()).sum();
                }

                @Override
                public float getProgress() {
                    float combined = 0.0f;
                    for (int i = 0; i < parts.size(); ++i) {
                        combined += ((PopulationProgress)parts.get(i).first()).getProgress() * weightFactors[i];
                    }
                    return combined;
                }

                @Override
                public IndexPopulationProgress toIndexPopulationProgress() {
                    float progress = this.getProgress();
                    long fakeTotal = 1000L;
                    long fakeCompleted = (long)((float)fakeTotal * progress);
                    return new IndexPopulationProgress(fakeCompleted, fakeTotal);
                }
            };
        }

        private float[] buildWeightFactors() {
            float[] weightFactors = new float[this.parts.size()];
            float weightSum = 0.0f;
            for (int i = 0; i < this.parts.size(); ++i) {
                Pair<PopulationProgress, Float> part = this.parts.get(i);
                weightFactors[i] = i == this.parts.size() - 1 ? 1.0f - weightSum : ((Float)part.other()).floatValue() / this.totalWeight;
                weightSum += weightFactors[i];
            }
            return weightFactors;
        }
    }
}

