/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.concurrent.atomic.AtomicInteger;

class CloseableByteBuffer {
    private volatile ByteBuffer delegate;
    private final AtomicInteger dupCount;

    private CloseableByteBuffer(ByteBuffer delegate) {
        this.delegate = delegate;
        this.dupCount = new AtomicInteger(0);
    }

    public final void close() {
        this.dupCount.decrementAndGet();
    }

    public static CloseableByteBuffer wrap(ByteBuffer delegate) {
        return new CloseableByteBuffer(delegate);
    }

    public final int capacity() {
        return this.delegate.capacity();
    }

    public final int position() {
        return this.delegate.position();
    }

    public final Buffer position(int newPosition) {
        return this.delegate.position(newPosition);
    }

    public final int limit() {
        return this.delegate.limit();
    }

    public final CloseableByteBuffer limit(int newLimit) {
        this.delegate.limit(newLimit);
        return this;
    }

    public final CloseableByteBuffer mark() {
        this.delegate.mark();
        return this;
    }

    public final CloseableByteBuffer reset() {
        this.delegate.reset();
        return this;
    }

    public final CloseableByteBuffer clear() {
        if (this.dupCount.get() > 0) {
            this.delegate = ByteBuffer.allocate(this.capacity());
        } else {
            this.delegate.clear();
        }
        return this;
    }

    public final CloseableByteBuffer flip() {
        this.delegate.flip();
        return this;
    }

    public final CloseableByteBuffer rewind() {
        this.delegate.rewind();
        return this;
    }

    public final int remaining() {
        return this.delegate.remaining();
    }

    public final boolean hasRemaining() {
        return this.delegate.hasRemaining();
    }

    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    public CloseableByteBuffer slice() {
        this.delegate.slice();
        return this;
    }

    public CloseableByteBuffer duplicate() {
        this.dupCount.incrementAndGet();
        return CloseableByteBuffer.wrap(this.delegate.duplicate());
    }

    public CharBuffer asCharBuffer() {
        return this.delegate.asCharBuffer();
    }

    ByteBuffer getDelegate() {
        return this.delegate;
    }

    public byte get() {
        return this.delegate.get();
    }

    public CloseableByteBuffer put(byte b) {
        this.delegate.put(b);
        return this;
    }

    public byte get(int index) {
        return this.delegate.get(index);
    }

    public CloseableByteBuffer put(int index, byte b) {
        this.delegate.put(index, b);
        return this;
    }

    public CloseableByteBuffer get(byte[] dst, int offset, int length) {
        this.delegate.get(dst, offset, length);
        return this;
    }

    public CloseableByteBuffer get(byte[] dst) {
        this.delegate.get(dst);
        return this;
    }

    public CloseableByteBuffer put(ByteBuffer src) {
        this.delegate.put(src);
        return this;
    }

    public CloseableByteBuffer put(byte[] src, int offset, int length) {
        this.delegate.put(src, offset, length);
        return this;
    }

    public final CloseableByteBuffer put(byte[] src) {
        this.delegate.put(src);
        return this;
    }

    public final boolean hasArray() {
        return this.delegate.hasArray();
    }

    public final byte[] array() {
        return this.delegate.array();
    }

    public final int arrayOffset() {
        return this.delegate.arrayOffset();
    }

    public CloseableByteBuffer compact() {
        this.delegate.compact();
        return this;
    }

    public boolean isDirect() {
        return this.delegate.isDirect();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object ob) {
        return this.delegate.equals(ob);
    }

    public int compareTo(ByteBuffer that) {
        return this.delegate.compareTo(that);
    }

    public final ByteOrder order() {
        return this.delegate.order();
    }

    public final CloseableByteBuffer order(ByteOrder bo) {
        this.delegate.order(bo);
        return this;
    }

    public char getChar() {
        return this.delegate.getChar();
    }

    public CloseableByteBuffer putChar(char value) {
        this.delegate.putChar(value);
        return this;
    }

    public char getChar(int index) {
        return this.delegate.getChar(index);
    }

    public CloseableByteBuffer putChar(int index, char value) {
        this.delegate.putChar(index, value);
        return this;
    }

    public short getShort() {
        return this.delegate.getShort();
    }

    public CloseableByteBuffer putShort(short value) {
        this.delegate.putShort(value);
        return this;
    }

    public short getShort(int index) {
        return this.delegate.getShort(index);
    }

    public CloseableByteBuffer putShort(int index, short value) {
        this.delegate.putShort(index, value);
        return this;
    }

    public int getInt() {
        return this.delegate.getInt();
    }

    public CloseableByteBuffer putInt(int value) {
        this.delegate.putInt(value);
        return this;
    }

    public int getInt(int index) {
        return this.delegate.getInt(index);
    }

    public CloseableByteBuffer putInt(int index, int value) {
        this.delegate.putInt(index, value);
        return this;
    }

    public long getLong() {
        return this.delegate.getLong();
    }

    public CloseableByteBuffer putLong(long value) {
        this.delegate.putLong(value);
        return this;
    }

    public long getLong(int index) {
        return this.delegate.getLong(index);
    }

    public CloseableByteBuffer putLong(int index, long value) {
        this.delegate.putLong(index, value);
        return this;
    }

    public float getFloat() {
        return this.delegate.getFloat();
    }

    public CloseableByteBuffer putFloat(float value) {
        this.delegate.putFloat(value);
        return this;
    }

    public float getFloat(int index) {
        return this.delegate.getFloat(index);
    }

    public CloseableByteBuffer putFloat(int index, float value) {
        this.delegate.putFloat(index, value);
        return this;
    }

    public double getDouble() {
        return this.delegate.getDouble();
    }

    public CloseableByteBuffer putDouble(double value) {
        this.delegate.putDouble(value);
        return this;
    }

    public double getDouble(int index) {
        return this.delegate.getDouble(index);
    }

    public CloseableByteBuffer putDouble(int index, double value) {
        this.delegate.putDouble(index, value);
        return this;
    }
}

