/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

@Deprecated
public class StoreLocker {
    public static final String STORE_LOCK_FILENAME = "store_lock";
    private final FileSystemAbstraction fileSystemAbstraction;
    private FileLock storeLockFileLock;
    private FileChannel storeLockFileChannel;

    public StoreLocker(FileSystemAbstraction fileSystemAbstraction) {
        this.fileSystemAbstraction = fileSystemAbstraction;
    }

    public void checkLock(File storeDir) throws StoreLockException {
        File storeLockFile = new File(storeDir, STORE_LOCK_FILENAME);
        try {
            if (!this.fileSystemAbstraction.fileExists(storeLockFile)) {
                this.fileSystemAbstraction.mkdirs(storeLockFile.getParentFile());
            }
        }
        catch (IOException e) {
            throw new StoreLockException("Unable to create path for store dir: " + storeDir + ". Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)", e);
        }
        try {
            this.storeLockFileChannel = this.fileSystemAbstraction.open(storeLockFile, "rw");
            this.storeLockFileLock = this.fileSystemAbstraction.tryLock(storeLockFile, this.storeLockFileChannel);
        }
        catch (OverlappingFileLockException e) {
            throw new StoreLockException("Unable to obtain lock on store lock file: " + storeLockFile + ". Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)", e);
        }
        catch (IOException e) {
            throw new StoreLockException("Unable to obtain lock on store lock file: " + storeLockFile + ". Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)", e);
        }
    }

    public void release() throws IOException {
        if (this.storeLockFileLock != null) {
            this.storeLockFileLock.release();
            this.storeLockFileLock = null;
        }
        if (this.storeLockFileChannel != null) {
            this.storeLockFileChannel.close();
            this.storeLockFileChannel = null;
        }
    }
}

