/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.impl.nioneo.store.LockableWindow;

class BrickElement {
    private final int index;
    private int hitCount;
    private int hitCountSnapshot;
    private volatile LockableWindow window;
    final AtomicInteger lockCount = new AtomicInteger();

    BrickElement(int index) {
        this.index = index;
    }

    void setWindow(LockableWindow window) {
        this.window = window;
    }

    LockableWindow getWindow() {
        return this.window;
    }

    int index() {
        return this.index;
    }

    void setHit() {
        this.hitCount += 10;
        if (this.hitCount < 0) {
            this.hitCount -= 10;
        }
    }

    int getHit() {
        return this.hitCount;
    }

    void refresh() {
        this.hitCount = this.window == null ? (int)((double)this.hitCount / 1.25) : (int)((double)this.hitCount / 1.15);
    }

    void snapshotHitCount() {
        this.hitCountSnapshot = this.hitCount;
    }

    int getHitCountSnapshot() {
        return this.hitCountSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LockableWindow getAndMarkWindow() {
        try {
            LockableWindow candidate = this.window;
            if (candidate != null && candidate.markAsInUse()) {
                LockableWindow lockableWindow = candidate;
                return lockableWindow;
            }
            this.lock();
            candidate = this.window;
            if (candidate != null && candidate.markAsInUse()) {
                this.unLock();
            }
            LockableWindow lockableWindow = candidate;
            return lockableWindow;
        }
        finally {
            this.setHit();
        }
    }

    synchronized void lock() {
        this.lockCount.incrementAndGet();
    }

    void unLock() {
        int lockCountAfterDecrement = this.lockCount.decrementAndGet();
        assert (lockCountAfterDecrement >= 0) : "Should not be able to have negative lock count " + lockCountAfterDecrement;
    }

    public String toString() {
        return "" + this.hitCount + (this.window == null ? "x" : "o");
    }
}

