/*
 * Copyright (c) 2002-2016 "Neo Technology,"
 * Network Engine for Objects in Lund AB [http://neotechnology.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.function.Function;

import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;

/**
 * Produces a {@link CharSeeker} that can seek and extract values from a csv/tsv style data stream.
 * A decorator also comes with it which can specify global overrides/defaults of extracted input entities.
 */
public interface Data<ENTITY extends InputEntity>
{
    CharSeeker stream();

    Function<ENTITY,ENTITY> decorator();
}
