/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.api.index.UpdateMode;

public class NodePropertyUpdate {
    private final long nodeId;
    private final int propertyKeyId;
    private final Object valueBefore;
    private final Object valueAfter;
    private final UpdateMode updateMode;
    private final long[] labelsBefore;
    private final long[] labelsAfter;

    private NodePropertyUpdate(long nodeId, int propertyKeyId, Object valueBefore, long[] labelsBefore, Object valueAfter, long[] labelsAfter, UpdateMode updateMode) {
        this.nodeId = nodeId;
        this.propertyKeyId = propertyKeyId;
        this.valueBefore = valueBefore;
        this.labelsBefore = labelsBefore;
        this.valueAfter = valueAfter;
        this.labelsAfter = labelsAfter;
        this.updateMode = updateMode;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getPropertyKeyId() {
        return this.propertyKeyId;
    }

    public Object getValueBefore() {
        return this.valueBefore;
    }

    public Object getValueAfter() {
        return this.valueAfter;
    }

    public int getNumberOfLabelsBefore() {
        return this.labelsBefore.length;
    }

    public int getLabelBefore(int i) {
        return (int)this.labelsBefore[i];
    }

    public int getNumberOfLabelsAfter() {
        return this.labelsAfter.length;
    }

    public int getLabelAfter(int i) {
        return (int)this.labelsAfter[i];
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public long[] getLabelsBefore() {
        return this.labelsBefore;
    }

    public long[] getLabelsAfter() {
        return this.labelsAfter;
    }

    public boolean forLabel(long labelId) {
        return this.updateMode.forLabel(this.labelsBefore, this.labelsAfter, labelId);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append("[").append(this.nodeId).append(", prop:").append(this.propertyKeyId).append(" ");
        switch (this.updateMode) {
            case ADDED: {
                result.append("add:").append(this.valueAfter);
                break;
            }
            case CHANGED: {
                result.append("change:").append(this.valueBefore).append(" => ").append(this.valueAfter);
                break;
            }
            case REMOVED: {
                result.append("remove:").append(this.valueBefore);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.updateMode.toString());
            }
        }
        result.append(", labelsBefore:").append(Arrays.toString(this.labelsBefore));
        result.append(", labelsAfter:").append(Arrays.toString(this.labelsAfter));
        return result.append("]").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.labelsBefore);
        result = 31 * result + Arrays.hashCode(this.labelsAfter);
        result = 31 * result + (int)(this.nodeId ^ this.nodeId >>> 32);
        result = 31 * result + this.propertyKeyId;
        result = 31 * result + this.updateMode.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodePropertyUpdate other = (NodePropertyUpdate)obj;
        return Arrays.equals(this.labelsBefore, other.labelsBefore) && Arrays.equals(this.labelsAfter, other.labelsAfter) && this.nodeId == other.nodeId && this.propertyKeyId == other.propertyKeyId && this.updateMode == other.updateMode && NodePropertyUpdate.propertyValuesEqual(this.valueBefore, other.valueBefore) && NodePropertyUpdate.propertyValuesEqual(this.valueAfter, other.valueAfter);
    }

    public static boolean propertyValuesEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof boolean[] && b instanceof boolean[]) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        if (a instanceof short[] && b instanceof short[]) {
            return Arrays.equals((short[])a, (short[])b);
        }
        if (a instanceof int[] && b instanceof int[]) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a instanceof long[] && b instanceof long[]) {
            return Arrays.equals((long[])a, (long[])b);
        }
        if (a instanceof char[] && b instanceof char[]) {
            return Arrays.equals((char[])a, (char[])b);
        }
        if (a instanceof float[] && b instanceof float[]) {
            return Arrays.equals((float[])a, (float[])b);
        }
        if (a instanceof double[] && b instanceof double[]) {
            return Arrays.equals((double[])a, (double[])b);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return Arrays.equals((Object[])a, (Object[])b);
        }
        return a.equals(b);
    }

    public static NodePropertyUpdate add(long nodeId, int propertyKeyId, Object value, long[] labels) {
        return new NodePropertyUpdate(nodeId, propertyKeyId, null, PrimitiveLongCollections.EMPTY_LONG_ARRAY, value, labels, UpdateMode.ADDED);
    }

    public static NodePropertyUpdate change(long nodeId, int propertyKeyId, Object valueBefore, long[] labelsBefore, Object valueAfter, long[] labelsAfter) {
        return new NodePropertyUpdate(nodeId, propertyKeyId, valueBefore, labelsBefore, valueAfter, labelsAfter, UpdateMode.CHANGED);
    }

    public static NodePropertyUpdate remove(long nodeId, int propertyKeyId, Object value, long[] labels) {
        return new NodePropertyUpdate(nodeId, propertyKeyId, value, labels, null, PrimitiveLongCollections.EMPTY_LONG_ARRAY, UpdateMode.REMOVED);
    }
}

