/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.IntSupplier;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.cursor.IntValue;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.cursor.NodeItemHelper;
import org.neo4j.kernel.impl.api.store.StoreLabelCursor;
import org.neo4j.kernel.impl.api.store.StoreNodeRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleLabelCursor;
import org.neo4j.kernel.impl.api.store.StoreSinglePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.storageengine.api.DegreeItem;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;

public abstract class StoreAbstractNodeCursor
extends NodeItemHelper
implements Cursor<NodeItem>,
NodeItem {
    protected final NodeRecord nodeRecord;
    protected final NodeStore nodeStore;
    protected final RelationshipStore relationshipStore;
    protected final RecordStore<RelationshipGroupRecord> relationshipGroupStore;
    protected final StoreStatement storeStatement;
    private final LockService lockService;
    private final InstanceCache<StoreLabelCursor> labelCursor;
    private final InstanceCache<StoreSingleLabelCursor> singleLabelCursor;
    private final InstanceCache<StoreNodeRelationshipCursor> nodeRelationshipCursor;
    private final InstanceCache<StoreSinglePropertyCursor> singlePropertyCursor;
    private final InstanceCache<StorePropertyCursor> allPropertyCursor;
    protected final RecordCursors cursors;
    private AssertOpen assertOpen;

    public StoreAbstractNodeCursor(NodeRecord nodeRecord, NeoStores neoStores, StoreStatement storeStatement, final RecordCursors cursors, final LockService lockService) {
        this.nodeRecord = nodeRecord;
        this.cursors = cursors;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.storeStatement = storeStatement;
        this.lockService = lockService;
        this.labelCursor = new InstanceCache<StoreLabelCursor>(){

            @Override
            protected StoreLabelCursor create() {
                return new StoreLabelCursor(cursors.label(), this);
            }
        };
        this.singleLabelCursor = new InstanceCache<StoreSingleLabelCursor>(){

            @Override
            protected StoreSingleLabelCursor create() {
                return new StoreSingleLabelCursor(cursors.label(), this);
            }
        };
        this.nodeRelationshipCursor = new InstanceCache<StoreNodeRelationshipCursor>(){

            @Override
            protected StoreNodeRelationshipCursor create() {
                return new StoreNodeRelationshipCursor((RelationshipRecord)StoreAbstractNodeCursor.this.relationshipStore.newRecord(), StoreAbstractNodeCursor.this.relationshipGroupStore.newRecord(), this, cursors, lockService);
            }
        };
        this.singlePropertyCursor = new InstanceCache<StoreSinglePropertyCursor>(){

            @Override
            protected StoreSinglePropertyCursor create() {
                return new StoreSinglePropertyCursor(cursors, this);
            }
        };
        this.allPropertyCursor = new InstanceCache<StorePropertyCursor>(){

            @Override
            protected StorePropertyCursor create() {
                return new StorePropertyCursor(cursors, StoreAbstractNodeCursor.this.allPropertyCursor);
            }
        };
    }

    protected void initialize(AssertOpen assertOpen) {
        this.assertOpen = assertOpen;
    }

    public NodeItem get() {
        return this;
    }

    @Override
    public long id() {
        return this.nodeRecord.getId();
    }

    @Override
    public Cursor<LabelItem> labels() {
        return this.labelCursor.get().init(this.nodeRecord);
    }

    @Override
    public Cursor<LabelItem> label(int labelId) {
        return this.singleLabelCursor.get().init(this.nodeRecord, labelId);
    }

    private Lock shortLivedReadLock() {
        Lock lock = this.lockService.acquireNodeLock(this.nodeRecord.getId(), LockService.LockType.READ_LOCK);
        if (this.lockService != LockService.NO_LOCK_SERVICE) {
            boolean success = false;
            try {
                if (!this.cursors.node().next(this.nodeRecord.getId(), this.nodeRecord, RecordLoad.CHECK)) {
                    this.nodeRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
                }
                success = true;
            }
            finally {
                if (!success) {
                    lock.release();
                }
            }
        }
        return lock;
    }

    @Override
    public Cursor<PropertyItem> properties() {
        return this.allPropertyCursor.get().init(this.nodeRecord.getNextProp(), this.shortLivedReadLock(), this.assertOpen);
    }

    @Override
    public Cursor<PropertyItem> property(int propertyKeyId) {
        return this.singlePropertyCursor.get().init(this.nodeRecord.getNextProp(), propertyKeyId, this.shortLivedReadLock(), this.assertOpen);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction) {
        return this.nodeRelationshipCursor.get().init(this.nodeRecord.isDense(), this.nodeRecord.getNextRel(), this.nodeRecord.getId(), direction, this.assertOpen);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction, int ... relTypes) {
        return this.nodeRelationshipCursor.get().init(this.nodeRecord.isDense(), this.nodeRecord.getNextRel(), this.nodeRecord.getId(), direction, this.assertOpen, relTypes);
    }

    @Override
    public Cursor<IntSupplier> relationshipTypes() {
        if (this.nodeRecord.isDense()) {
            return new Cursor<IntSupplier>(){
                private long groupId;
                private final IntValue value;
                private final RelationshipGroupRecord group;
                {
                    this.groupId = StoreAbstractNodeCursor.this.nodeRecord.getNextRel();
                    this.value = new IntValue();
                    this.group = StoreAbstractNodeCursor.this.relationshipGroupStore.newRecord();
                }

                public boolean next() {
                    while (this.groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                        boolean groupRecordInUse = StoreAbstractNodeCursor.this.cursors.relationshipGroup().next(this.groupId, this.group, RecordLoad.FORCE);
                        this.groupId = this.group.getNext();
                        if (!groupRecordInUse) continue;
                        this.value.setValue(this.group.getType());
                        return true;
                    }
                    return false;
                }

                public void close() {
                }

                public IntSupplier get() {
                    return this.value;
                }
            };
        }
        final Cursor<RelationshipItem> relationships = this.relationships(Direction.BOTH);
        return new Cursor<IntSupplier>(){
            private final PrimitiveIntSet foundTypes = Primitive.intSet((int)5);
            private final IntValue value = new IntValue();

            public boolean next() {
                while (relationships.next()) {
                    if (this.foundTypes.contains(((RelationshipItem)relationships.get()).type())) continue;
                    this.foundTypes.add(((RelationshipItem)relationships.get()).type());
                    this.value.setValue(((RelationshipItem)relationships.get()).type());
                    return true;
                }
                return false;
            }

            public void close() {
            }

            public IntSupplier get() {
                return this.value;
            }
        };
    }

    @Override
    public int degree(Direction direction) {
        if (this.nodeRecord.isDense()) {
            long groupId = this.nodeRecord.getNextRel();
            long count = 0L;
            RelationshipGroupRecord group = this.relationshipGroupStore.newRecord();
            RelationshipRecord relationship = (RelationshipRecord)this.relationshipStore.newRecord();
            while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                boolean groupRecordInUse = this.cursors.relationshipGroup().next(groupId, group, RecordLoad.FORCE);
                if (groupRecordInUse) {
                    count += this.nodeDegreeByDirection(group, direction, relationship);
                }
                groupId = group.getNext();
            }
            return (int)count;
        }
        try (Cursor<RelationshipItem> relationship = this.relationships(direction);){
            int count = 0;
            while (relationship.next()) {
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public int degree(Direction direction, int relType) {
        if (this.nodeRecord.isDense()) {
            long groupId = this.nodeRecord.getNextRel();
            RelationshipGroupRecord group = this.relationshipGroupStore.newRecord();
            RelationshipRecord relationship = (RelationshipRecord)this.relationshipStore.newRecord();
            while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                boolean groupRecordInUse = this.cursors.relationshipGroup().next(groupId, group, RecordLoad.FORCE);
                if (groupRecordInUse && group.getType() == relType) {
                    return (int)this.nodeDegreeByDirection(group, direction, relationship);
                }
                groupId = group.getNext();
            }
            return 0;
        }
        try (Cursor<RelationshipItem> relationship = this.relationships(direction, relType);){
            int count = 0;
            while (relationship.next()) {
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public Cursor<DegreeItem> degrees() {
        if (this.nodeRecord.isDense()) {
            long groupId = this.nodeRecord.getNextRel();
            return new DegreeItemDenseCursor(groupId);
        }
        PrimitiveIntObjectMap degrees = Primitive.intObjectMap((int)5);
        try (Cursor<RelationshipItem> relationship = this.relationships(Direction.BOTH);){
            while (relationship.next()) {
                RelationshipItem rel = (RelationshipItem)relationship.get();
                int[] byType = (int[])degrees.get(rel.type());
                if (byType == null) {
                    byType = new int[3];
                    degrees.put(rel.type(), (Object)byType);
                }
                int n = this.directionOf(this.nodeRecord.getId(), rel.id(), rel.startNode(), rel.endNode()).ordinal();
                byType[n] = byType[n] + 1;
            }
        }
        PrimitiveIntIterator keys = degrees.iterator();
        return new DegreeItemIterator(keys, (PrimitiveIntObjectMap<int[]>)degrees);
    }

    @Override
    public boolean isDense() {
        return this.nodeRecord.isDense();
    }

    private long nodeDegreeByDirection(RelationshipGroupRecord group, Direction direction, RelationshipRecord relationship) {
        long loopCount = this.countByFirstPrevPointer(group.getFirstLoop(), relationship);
        switch (direction) {
            case OUTGOING: {
                return this.countByFirstPrevPointer(group.getFirstOut(), relationship) + loopCount;
            }
            case INCOMING: {
                return this.countByFirstPrevPointer(group.getFirstIn(), relationship) + loopCount;
            }
            case BOTH: {
                return this.countByFirstPrevPointer(group.getFirstOut(), relationship) + this.countByFirstPrevPointer(group.getFirstIn(), relationship) + loopCount;
            }
        }
        throw new IllegalArgumentException(direction.name());
    }

    private long countByFirstPrevPointer(long relationshipId, RelationshipRecord record) {
        if (relationshipId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return 0L;
        }
        this.cursors.relationship().next(relationshipId, record, RecordLoad.FORCE);
        if (record.getFirstNode() == this.nodeRecord.getId()) {
            return record.getFirstPrevRel();
        }
        if (record.getSecondNode() == this.nodeRecord.getId()) {
            return record.getSecondPrevRel();
        }
        throw new InvalidRecordException("Node " + this.nodeRecord.getId() + " neither start nor end node of " + record);
    }

    private Direction directionOf(long nodeId, long relationshipId, long startNode, long endNode) {
        if (startNode == nodeId) {
            return endNode == nodeId ? Direction.BOTH : Direction.OUTGOING;
        }
        if (endNode == nodeId) {
            return Direction.INCOMING;
        }
        throw new InvalidRecordException("Node " + nodeId + " neither start nor end node of relationship " + relationshipId + " with startNode:" + startNode + " and endNode:" + endNode);
    }

    private class DegreeItemDenseCursor
    implements Cursor<DegreeItem>,
    DegreeItem {
        private long groupId;
        private int type;
        private long outgoing;
        private long incoming;
        private final RelationshipGroupRecord group;
        private final RelationshipRecord relationship;

        public DegreeItemDenseCursor(long groupId) {
            this.group = StoreAbstractNodeCursor.this.relationshipGroupStore.newRecord();
            this.relationship = (RelationshipRecord)StoreAbstractNodeCursor.this.relationshipStore.newRecord();
            this.groupId = groupId;
        }

        public boolean next() {
            while (this.groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                boolean groupRecordInUse = StoreAbstractNodeCursor.this.cursors.relationshipGroup().next(this.groupId, this.group, RecordLoad.FORCE);
                this.groupId = this.group.getNext();
                if (!groupRecordInUse) continue;
                this.type = this.group.getType();
                long loop = StoreAbstractNodeCursor.this.countByFirstPrevPointer(this.group.getFirstLoop(), this.relationship);
                this.outgoing = StoreAbstractNodeCursor.this.countByFirstPrevPointer(this.group.getFirstOut(), this.relationship) + loop;
                this.incoming = StoreAbstractNodeCursor.this.countByFirstPrevPointer(this.group.getFirstIn(), this.relationship) + loop;
                return true;
            }
            return false;
        }

        public void close() {
        }

        public DegreeItem get() {
            return this;
        }

        @Override
        public int type() {
            return this.type;
        }

        @Override
        public long outgoing() {
            return this.outgoing;
        }

        @Override
        public long incoming() {
            return this.incoming;
        }
    }

    private static class DegreeItemIterator
    implements Cursor<DegreeItem>,
    DegreeItem {
        private final PrimitiveIntObjectMap<int[]> degrees;
        private PrimitiveIntIterator keys;
        private int type;
        private int outgoing;
        private int incoming;

        public DegreeItemIterator(PrimitiveIntIterator keys, PrimitiveIntObjectMap<int[]> degrees) {
            this.keys = keys;
            this.degrees = degrees;
        }

        public void close() {
            this.keys = null;
        }

        @Override
        public int type() {
            return this.type;
        }

        @Override
        public long outgoing() {
            return this.outgoing;
        }

        @Override
        public long incoming() {
            return this.incoming;
        }

        public DegreeItem get() {
            if (this.keys == null) {
                throw new IllegalStateException();
            }
            return this;
        }

        public boolean next() {
            if (this.keys != null && this.keys.hasNext()) {
                this.type = this.keys.next();
                int[] degreeValues = (int[])this.degrees.get(this.type);
                this.outgoing = degreeValues[0] + degreeValues[2];
                this.incoming = degreeValues[1] + degreeValues[2];
                return true;
            }
            this.keys = null;
            return false;
        }
    }
}

