/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public interface RecordCursor<R extends AbstractBaseRecord>
extends Cursor<R> {
    public RecordCursor<R> acquire(long var1, RecordLoad var3);

    public void placeAt(long var1, RecordLoad var3);

    public boolean next();

    public boolean next(long var1);

    public boolean next(long var1, R var3, RecordLoad var4);

    default public List<R> getAll() {
        ArrayList<AbstractBaseRecord> recordList = new ArrayList<AbstractBaseRecord>();
        while (this.next()) {
            recordList.add(((AbstractBaseRecord)this.get()).clone());
        }
        return recordList;
    }

    public static class Delegator<R extends AbstractBaseRecord>
    implements RecordCursor<R> {
        private final RecordCursor<R> actual;

        public Delegator(RecordCursor<R> actual) {
            this.actual = actual;
        }

        public R get() {
            return (R)((AbstractBaseRecord)this.actual.get());
        }

        @Override
        public boolean next() {
            return this.actual.next();
        }

        @Override
        public void placeAt(long id, RecordLoad mode) {
            this.actual.placeAt(id, mode);
        }

        public void close() {
            this.actual.close();
        }

        @Override
        public RecordCursor<R> acquire(long id, RecordLoad mode) {
            this.actual.acquire(id, mode);
            return this;
        }

        @Override
        public boolean next(long id) {
            return this.actual.next(id);
        }

        @Override
        public boolean next(long id, R record, RecordLoad mode) {
            return this.actual.next(id, record, mode);
        }
    }
}

