/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts.keys;

import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.store.counts.keys.IndexKey;

public final class IndexStatisticsKey
extends IndexKey {
    IndexStatisticsKey(int labelId, int propertyKeyId) {
        super(labelId, propertyKeyId, CountsKeyType.INDEX_STATISTICS);
    }

    @Override
    public void accept(CountsVisitor visitor, long updates, long size) {
        visitor.visitIndexStatistics(this.labelId(), this.propertyKeyId(), updates, size);
    }

    @Override
    public int compareTo(CountsKey other) {
        if (other instanceof IndexStatisticsKey) {
            IndexStatisticsKey that = (IndexStatisticsKey)other;
            int cmp = this.labelId() - that.labelId();
            if (cmp == 0) {
                cmp = this.propertyKeyId() - that.propertyKeyId();
            }
            return cmp;
        }
        return this.recordType().ordinal() - other.recordType().ordinal();
    }
}

