/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.Arrays;
import java.util.TimeZone;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;

public class LogEntryStart
extends AbstractLogEntry {
    public static final byte[] EMPTY_ADDITIONAL_ARRAY = new byte[0];
    private final int masterId;
    private final int authorId;
    private final long timeWritten;
    private final long lastCommittedTxWhenTransactionStarted;
    private final byte[] additionalHeader;
    private LogPosition startPosition;

    public LogEntryStart(int masterId, int authorId, long timeWritten, long lastCommittedTxWhenTransactionStarted, byte[] additionalHeader, LogPosition startPosition) {
        this(LogEntryVersion.CURRENT, masterId, authorId, timeWritten, lastCommittedTxWhenTransactionStarted, additionalHeader, startPosition);
    }

    public LogEntryStart(LogEntryVersion version, int masterId, int authorId, long timeWritten, long lastCommittedTxWhenTransactionStarted, byte[] additionalHeader, LogPosition startPosition) {
        super(version, (byte)1);
        this.masterId = masterId;
        this.authorId = authorId;
        this.startPosition = startPosition;
        this.timeWritten = timeWritten;
        this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        this.additionalHeader = additionalHeader;
    }

    public int getMasterId() {
        return this.masterId;
    }

    public int getLocalId() {
        return this.authorId;
    }

    public LogPosition getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(LogPosition position) {
        this.startPosition = position;
    }

    public long getTimeWritten() {
        return this.timeWritten;
    }

    public long getLastCommittedTxWhenTransactionStarted() {
        return this.lastCommittedTxWhenTransactionStarted;
    }

    public byte[] getAdditionalHeader() {
        return this.additionalHeader;
    }

    public static long checksum(byte[] additionalHeader, int masterId, int authorId) {
        long lowBits = Arrays.hashCode(additionalHeader);
        long highBits = masterId * 37 + authorId;
        return highBits << 32 | lowBits & 0xFFFFFFFFL;
    }

    public static long checksum(LogEntryStart entry) {
        return LogEntryStart.checksum(entry.additionalHeader, entry.masterId, entry.authorId);
    }

    public long checksum() {
        return LogEntryStart.checksum(this);
    }

    public String toString() {
        return this.toString(Format.DEFAULT_TIME_ZONE);
    }

    @Override
    public String toString(TimeZone timeZone) {
        return "Start[master=" + this.masterId + ",me=" + this.authorId + ",time=" + this.timestamp(this.timeWritten, timeZone) + ",lastCommittedTxWhenTransactionStarted=" + this.lastCommittedTxWhenTransactionStarted + ",additionalHeaderLength=" + (this.additionalHeader == null ? -1 : this.additionalHeader.length) + "," + (this.additionalHeader == null ? "" : Arrays.toString(this.additionalHeader)) + ",position=" + this.startPosition + ",checksum=" + LogEntryStart.checksum(this) + "]";
    }

    @Override
    public <T extends LogEntry> T as() {
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryStart start = (LogEntryStart)o;
        return this.authorId == start.authorId && this.lastCommittedTxWhenTransactionStarted == start.lastCommittedTxWhenTransactionStarted && this.masterId == start.masterId && this.timeWritten == start.timeWritten && Arrays.equals(this.additionalHeader, start.additionalHeader) && this.startPosition.equals(start.startPosition);
    }

    public int hashCode() {
        int result = this.masterId;
        result = 31 * result + this.authorId;
        result = 31 * result + (int)(this.timeWritten ^ this.timeWritten >>> 32);
        result = 31 * result + (int)(this.lastCommittedTxWhenTransactionStarted ^ this.lastCommittedTxWhenTransactionStarted >>> 32);
        result = 31 * result + (this.additionalHeader != null ? Arrays.hashCode(this.additionalHeader) : 0);
        result = 31 * result + this.startPosition.hashCode();
        return result;
    }
}

