/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.GenericStatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;

public class MemoryUsageStatsProvider
extends GenericStatsProvider
implements Stat {
    private final MemoryStatsVisitor.Visitable[] users;

    public MemoryUsageStatsProvider(MemoryStatsVisitor.Visitable ... users) {
        this.users = users;
        this.add(Keys.memory_usage, this);
    }

    @Override
    public DetailLevel detailLevel() {
        return DetailLevel.IMPORTANT;
    }

    @Override
    public long asLong() {
        GatheringMemoryStatsVisitor visitor = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable user : this.users) {
            user.acceptMemoryStatsVisitor(visitor);
        }
        return visitor.getHeapUsage() + visitor.getOffHeapUsage();
    }

    @Override
    public String toString() {
        return Format.bytes(this.asLong());
    }
}

