/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;

public interface RecordIdIterator {
    public PrimitiveLongIterator nextBatch();

    public static RecordIdIterator backwards(long lowIncluded, long highExcluded, Configuration config) {
        return new Backwards(lowIncluded, highExcluded, config);
    }

    public static RecordIdIterator forwards(long lowIncluded, long highExcluded, Configuration config) {
        return new Forwards(lowIncluded, highExcluded, config);
    }

    public static RecordIdIterator allIn(RecordStore<? extends AbstractBaseRecord> store, Configuration config) {
        return RecordIdIterator.forwards(store.getNumberOfReservedLowIds(), store.getHighId(), config);
    }

    public static RecordIdIterator allInReversed(RecordStore<? extends AbstractBaseRecord> store, Configuration config) {
        return RecordIdIterator.backwards(store.getNumberOfReservedLowIds(), store.getHighId(), config);
    }

    public static class Backwards
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator
    implements RecordIdIterator {
        private final int batchSize;
        private final long lowIncluded;
        private final long highExcluded;
        private long nextRoofId;
        private long floorId;
        private long nextId;
        private boolean initialized;

        public Backwards(long lowIncluded, long highExcluded, Configuration config) {
            this.lowIncluded = lowIncluded;
            this.batchSize = config.batchSize();
            this.highExcluded = highExcluded;
            this.nextId = highExcluded;
            this.nextRoofId = highExcluded;
            this.floorId = highExcluded;
        }

        @Override
        public PrimitiveLongIterator nextBatch() {
            assert (!this.initialized || this.nextId == this.nextRoofId);
            long size = this.floorId - this.lowIncluded;
            if (size > 0L) {
                if (!this.initialized) {
                    this.nextId = this.floorId = this.findFloorId(this.nextRoofId);
                    this.initialized = true;
                } else {
                    this.nextRoofId = this.floorId;
                    this.nextId = this.floorId -= Long.min(size, this.batchSize);
                }
                return this;
            }
            return null;
        }

        private long findFloorId(long roofId) {
            int rest = (int)(roofId % (long)this.batchSize);
            return Long.max(rest == 0 ? roofId - (long)this.batchSize : roofId - (long)rest, this.lowIncluded);
        }

        protected boolean fetchNext() {
            return this.nextId < this.nextRoofId ? this.next(this.nextId++) : false;
        }

        public String toString() {
            return "]" + this.highExcluded + "-" + this.lowIncluded + "]";
        }
    }

    public static class Forwards
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator
    implements RecordIdIterator {
        private final long lowIncluded;
        private final long highExcluded;
        private final int batchSize;
        private long highBatchId;
        private long nextId;
        private boolean initialized;

        public Forwards(long lowIncluded, long highExcluded, Configuration config) {
            this.lowIncluded = lowIncluded;
            this.nextId = lowIncluded;
            this.highExcluded = highExcluded;
            this.batchSize = config.batchSize();
        }

        @Override
        public PrimitiveLongIterator nextBatch() {
            assert (!this.initialized || this.nextId == this.highBatchId);
            long size = Long.min(this.batchSize, this.highExcluded - this.nextId);
            if (size > 0L) {
                if (!this.initialized) {
                    this.highBatchId = this.findRoofId(this.lowIncluded);
                    this.initialized = true;
                } else {
                    this.highBatchId = Long.min(this.nextId + size, this.highBatchId + size);
                }
                return this;
            }
            return null;
        }

        private long findRoofId(long floorId) {
            int rest = (int)(floorId % (long)this.batchSize);
            return Long.max(rest == 0 ? floorId + (long)this.batchSize : floorId + (long)this.batchSize - (long)rest, this.lowIncluded);
        }

        protected boolean fetchNext() {
            return this.nextId < this.highBatchId ? this.next(this.nextId++) : false;
        }

        public String toString() {
            return "[" + this.lowIncluded + "-" + this.highExcluded + "[";
        }
    }
}

