/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.api.query.ExecutingQueryStatus;
import org.neo4j.storageengine.api.lock.ResourceType;

class WaitingOnLock
extends ExecutingQueryStatus {
    private final String mode;
    private final ResourceType resourceType;
    private final long[] resourceIds;
    private final long startTimeNanos;

    WaitingOnLock(String mode, ResourceType resourceType, long[] resourceIds, long startTimeNanos) {
        this.mode = mode;
        this.resourceType = resourceType;
        this.resourceIds = resourceIds;
        this.startTimeNanos = startTimeNanos;
    }

    @Override
    long waitTimeNanos(long currentTimeNanos) {
        return currentTimeNanos - this.startTimeNanos;
    }

    @Override
    Map<String, Object> toMap(long currentTimeNanos) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lockMode", this.mode);
        map.put("waitTimeMillis", TimeUnit.NANOSECONDS.toMillis(this.waitTimeNanos(currentTimeNanos)));
        map.put("resourceType", this.resourceType.toString());
        map.put("resourceIds", this.resourceIds);
        return map;
    }

    @Override
    String name() {
        return "waiting";
    }
}

