/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;

class TwoPhaseNodeForRelationshipLocking {
    private final PrimitiveLongSet nodeIds = Primitive.longSet();
    private final EntityReadOperations entityReadOperations;
    private final ThrowingConsumer<Long, KernelException> relIdAction;
    private long firstRelId;

    TwoPhaseNodeForRelationshipLocking(EntityReadOperations entityReadOperations, ThrowingConsumer<Long, KernelException> relIdAction) {
        this.entityReadOperations = entityReadOperations;
        this.relIdAction = relIdAction;
    }

    void lockAllNodesAndConsumeRelationships(long nodeId, KernelStatement state) throws KernelException {
        boolean retry;
        do {
            this.nodeIds.add(nodeId);
            retry = false;
            this.firstRelId = -1L;
            try (Cursor<NodeItem> node = this.entityReadOperations.nodeCursorById(state, nodeId);){
                this.entityReadOperations.nodeGetRelationships(state, (NodeItem)node.get(), Direction.BOTH).forAll(this::collectNodeId);
            }
            this.lockAllNodes(state);
            node = this.entityReadOperations.nodeCursorById(state, nodeId);
            var6_5 = null;
            try (Cursor<RelationshipItem> relationships = this.entityReadOperations.nodeGetRelationships(state, (NodeItem)node.get(), Direction.BOTH);){
                boolean first = true;
                while (relationships.next() && !retry) {
                    retry = this.performAction(state, (RelationshipItem)relationships.get(), first);
                    first = false;
                }
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
            finally {
                if (node != null) {
                    if (var6_5 != null) {
                        try {
                            node.close();
                        }
                        catch (Throwable throwable) {
                            var6_5.addSuppressed(throwable);
                        }
                    } else {
                        node.close();
                    }
                }
            }
        } while (retry);
    }

    private void lockAllNodes(KernelStatement state) {
        PrimitiveLongIterator nodeIdIterator = this.nodeIds.iterator();
        while (nodeIdIterator.hasNext()) {
            state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.NODE, nodeIdIterator.next());
        }
    }

    private void unlockAllNodes(KernelStatement state) {
        PrimitiveLongIterator iterator = this.nodeIds.iterator();
        while (iterator.hasNext()) {
            state.locks().optimistic().releaseExclusive(ResourceTypes.NODE, iterator.next());
        }
        this.nodeIds.clear();
    }

    private boolean performAction(KernelStatement state, RelationshipItem rel, boolean first) throws KernelException {
        if (first && rel.id() != this.firstRelId) {
            this.unlockAllNodes(state);
            return true;
        }
        this.relIdAction.accept((Object)rel.id());
        return false;
    }

    private void collectNodeId(RelationshipItem rel) {
        if (this.firstRelId == -1L) {
            this.firstRelId = rel.id();
        }
        this.nodeIds.add(rel.startNode());
        this.nodeIds.add(rel.endNode());
    }
}

