/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;

public class IndexMapReference
implements IndexMapSnapshotProvider {
    private volatile IndexMap indexMap = new IndexMap();

    @Override
    public IndexMap indexMapSnapshot() {
        return this.indexMap.clone();
    }

    public IndexProxy getIndexProxy(long indexId) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(indexId);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for index id " + indexId + " exists.");
        }
        return proxy;
    }

    public IndexProxy getIndexProxy(LabelSchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(descriptor);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for " + descriptor + " exists.");
        }
        return proxy;
    }

    public long getIndexId(LabelSchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.indexMap.getIndexProxy(descriptor);
        if (proxy == null) {
            throw new IndexNotFoundKernelException("No index for " + descriptor + " exists.");
        }
        return this.indexMap.getIndexId(descriptor);
    }

    public long getOnlineIndexId(LabelSchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy proxy = this.getIndexProxy(descriptor);
        switch (proxy.getState()) {
            case ONLINE: {
                return this.indexMap.getIndexId(descriptor);
            }
        }
        throw new IndexNotFoundKernelException("Expected index on " + descriptor + " to be online.");
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexMap.getAllIndexProxies();
    }

    public Iterable<LabelSchemaDescriptor> getRelatedIndexes(long[] changedLabels, long[] unchangedLabels, PrimitiveIntCollection properties) {
        return this.indexMap.getRelatedIndexes(changedLabels, unchangedLabels, properties);
    }

    public void setIndexMap(IndexMap newIndexMap) {
        this.indexMap = newIndexMap;
    }

    public IndexProxy removeIndexProxy(long indexId) {
        IndexMap newIndexMap = this.indexMapSnapshot();
        IndexProxy indexProxy = newIndexMap.removeIndexProxy(indexId);
        this.setIndexMap(newIndexMap);
        return indexProxy;
    }

    public Iterable<IndexProxy> clear() {
        IndexMap oldIndexMap = this.indexMap;
        this.setIndexMap(new IndexMap());
        return oldIndexMap.getAllIndexProxies();
    }

    public IndexUpdaterMap createIndexUpdaterMap(IndexUpdateMode mode) {
        return new IndexUpdaterMap(this.indexMap, mode);
    }
}

