/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyRecordChange;

public class PropertyPhysicalToLogicalConverter {
    private final PropertyStore propertyStore;

    public PropertyPhysicalToLogicalConverter(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
    }

    public void convertPropertyRecord(long nodeId, Iterable<PropertyRecordChange> changes, NodeUpdates.Builder properties) {
        HashMap<Integer, PropertyBlock> beforeMap = new HashMap<Integer, PropertyBlock>();
        HashMap<Integer, PropertyBlock> afterMap = new HashMap<Integer, PropertyBlock>();
        this.mapBlocks(nodeId, changes, beforeMap, afterMap);
        Iterator iterator = this.union(beforeMap.keySet(), afterMap.keySet()).iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            PropertyBlock beforeBlock = (PropertyBlock)beforeMap.get(key);
            PropertyBlock afterBlock = (PropertyBlock)afterMap.get(key);
            if (beforeBlock != null && afterBlock != null) {
                if (beforeBlock.hasSameContentsAs(afterBlock)) continue;
                Object beforeVal = this.valueOf(beforeBlock);
                Object afterVal = this.valueOf(afterBlock);
                properties.changed(key, beforeVal, afterVal);
                continue;
            }
            if (afterBlock != null) {
                properties.added(key, this.valueOf(afterBlock));
                continue;
            }
            if (beforeBlock != null) {
                properties.removed(key, this.valueOf(beforeBlock));
                continue;
            }
            throw new IllegalStateException("Weird, an update with no property value for before or after");
        }
    }

    private <T> Set<T> union(Set<T> first, Set<T> other) {
        HashSet<T> union = new HashSet<T>(first);
        union.addAll(other);
        return union;
    }

    private long mapBlocks(long nodeId, Iterable<PropertyRecordChange> changes, Map<Integer, PropertyBlock> beforeMap, Map<Integer, PropertyBlock> afterMap) {
        for (PropertyRecordChange change : changes) {
            this.equalCheck(change.getBefore().getNodeId(), nodeId);
            this.equalCheck(change.getAfter().getNodeId(), nodeId);
            this.mapBlocks(change.getBefore(), beforeMap);
            this.mapBlocks(change.getAfter(), afterMap);
        }
        return nodeId;
    }

    private void equalCheck(long nodeId, long expectedNodeId) {
        assert (nodeId == expectedNodeId) : "Node id differs expected " + expectedNodeId + ", but was " + nodeId;
    }

    private void mapBlocks(PropertyRecord record, Map<Integer, PropertyBlock> blocks) {
        for (PropertyBlock block : record) {
            blocks.put(block.getKeyIndexId(), block);
        }
    }

    private Object valueOf(PropertyBlock block) {
        if (block == null) {
            return null;
        }
        return block.getType().getValue(block, this.propertyStore);
    }
}

