/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;

class StoreRecordCursor<RECORD extends AbstractBaseRecord>
implements RecordCursor<RECORD> {
    private final RECORD record;
    private CommonAbstractStore<RECORD, ?> store;
    private long currentId;
    private RecordLoad mode;
    private PageCursor pageCursor;

    StoreRecordCursor(RECORD record, CommonAbstractStore<RECORD, ?> store) {
        this.record = record;
        this.store = store;
    }

    @Override
    public boolean next() {
        try {
            boolean bl = this.next(this.currentId, this.record, this.mode);
            return bl;
        }
        finally {
            this.currentId = this.store.getNextRecordReference(this.record);
        }
    }

    @Override
    public boolean next(long id) {
        return this.next(id, this.record, this.mode);
    }

    @Override
    public boolean next(long id, RECORD record, RecordLoad mode) {
        assert (this.pageCursor != null) : "Not initialized";
        if (Record.NULL_REFERENCE.is(id)) {
            ((AbstractBaseRecord)record).clear();
            ((AbstractBaseRecord)record).setId(Record.NULL_REFERENCE.intValue());
            return false;
        }
        try {
            this.store.readIntoRecord(id, record, mode, this.pageCursor);
            return ((AbstractBaseRecord)record).inUse();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void placeAt(long id, RecordLoad mode) {
        this.currentId = id;
        this.mode = mode;
    }

    public void close() {
        assert (this.pageCursor != null);
        this.pageCursor.close();
        this.pageCursor = null;
    }

    public RECORD get() {
        return this.record;
    }

    @Override
    public RecordCursor<RECORD> acquire(long id, RecordLoad mode) {
        assert (this.pageCursor == null);
        this.currentId = id;
        this.mode = mode;
        try {
            this.pageCursor = this.store.storeFile.io(this.store.pageIdForRecord(id), 1);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        return this;
    }
}

