/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.Optional;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsUpdater;
import org.neo4j.kernel.impl.store.counts.FileVersion;
import org.neo4j.kernel.impl.store.counts.KeyFormat;
import org.neo4j.kernel.impl.store.counts.ValueRegister;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.kvstore.AbstractKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.MetadataVisitor;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.Rotation;
import org.neo4j.kernel.impl.store.kvstore.RotationMonitor;
import org.neo4j.kernel.impl.store.kvstore.RotationTimerFactory;
import org.neo4j.kernel.impl.store.kvstore.UnknownKey;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.time.Clocks;

@Rotation(value=Rotation.Strategy.LEFT_RIGHT, parameters={".a", ".b"})
public class CountsTracker
extends AbstractKeyValueStore<CountsKey>
implements CountsVisitor.Visitable,
CountsAccessor {
    private static final byte[] FORMAT = new byte[]{78, 101, 111, 67, 111, 117, 110, 116, 83, 116, 111, 114, 101, 0, 2, 86};
    private static final HeaderField<?>[] HEADER_FIELDS = new HeaderField[]{FileVersion.FILE_VERSION};
    public static final String LEFT = ".a";
    public static final String RIGHT = ".b";
    public static final String TYPE_DESCRIPTOR = "CountsStore";

    public CountsTracker(LogProvider logProvider, FileSystemAbstraction fs, PageCache pages, Config config, File baseFile) {
        this(logProvider, fs, pages, config, baseFile, Clocks.systemClock());
    }

    public CountsTracker(final LogProvider logProvider, FileSystemAbstraction fs, PageCache pages, Config config, File baseFile, Clock clock) {
        super(fs, pages, baseFile, new RotationMonitor(){
            final Log log;
            {
                this.log = logProvider.getLog(CountsTracker.class);
            }

            @Override
            public void failedToOpenStoreFile(File path, Exception error) {
                this.log.error("Failed to open counts store file: " + path, (Throwable)error);
            }

            @Override
            public void beforeRotation(File source, File target, Headers headers) {
                this.log.info(String.format("About to rotate counts store at transaction %d to [%s], from [%s].", headers.get(FileVersion.FILE_VERSION).txId, target, source));
            }

            @Override
            public void rotationSucceeded(File source, File target, Headers headers) {
                this.log.info(String.format("Successfully rotated counts store at transaction %d to [%s], from [%s].", headers.get(FileVersion.FILE_VERSION).txId, target, source));
            }

            @Override
            public void rotationFailed(File source, File target, Headers headers, Exception e) {
                this.log.error(String.format("Failed to rotate counts store at transaction %d to [%s], from [%s].", headers.get(FileVersion.FILE_VERSION).txId, target, source), (Throwable)e);
            }
        }, new RotationTimerFactory(clock, config.get(GraphDatabaseSettings.counts_store_rotation_timeout).toMillis()), 16, 16, HEADER_FIELDS);
    }

    public CountsTracker setInitializer(final DataInitializer<CountsAccessor.Updater> initializer) {
        this.setEntryUpdaterInitializer(new DataInitializer<EntryUpdater<CountsKey>>(){

            @Override
            public void initialize(EntryUpdater<CountsKey> updater) {
                initializer.initialize(new CountsUpdater(updater));
            }

            @Override
            public long initialVersion() {
                return initializer.initialVersion();
            }
        });
        return this;
    }

    public long rotate(long txId) throws IOException {
        return this.prepareRotation(txId).rotate();
    }

    public long txId() {
        return this.headers().get(FileVersion.FILE_VERSION).txId;
    }

    public long minorVersion() {
        return this.headers().get(FileVersion.FILE_VERSION).minorVersion;
    }

    public Register.DoubleLongRegister get(CountsKey key, Register.DoubleLongRegister target) {
        try {
            return this.lookup(key, new ValueRegister(target));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public Register.DoubleLongRegister nodeCount(int labelId, Register.DoubleLongRegister target) {
        return this.get(CountsKeyFactory.nodeKey(labelId), target);
    }

    @Override
    public Register.DoubleLongRegister relationshipCount(int startLabelId, int typeId, int endLabelId, Register.DoubleLongRegister target) {
        return this.get(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId), target);
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(long indexId, Register.DoubleLongRegister target) {
        return this.get(CountsKeyFactory.indexStatisticsKey(indexId), target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(long indexId, Register.DoubleLongRegister target) {
        return this.get(CountsKeyFactory.indexSampleKey(indexId), target);
    }

    public Optional<CountsAccessor.Updater> apply(long txId) {
        return this.updater(txId).map(CountsUpdater::new);
    }

    public CountsAccessor.IndexStatsUpdater updateIndexCounts() {
        return new CountsUpdater(this.updater());
    }

    public CountsAccessor.Updater reset(long txId) {
        return new CountsUpdater(this.resetter(txId));
    }

    @Override
    public void accept(CountsVisitor visitor) {
        try {
            this.visitAll(new DelegatingVisitor(visitor));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    protected void visitFile(File path, CountsVisitor visitor) throws IOException {
        super.visitFile(path, new DelegatingVisitor(visitor));
    }

    @Override
    protected Headers initialHeaders(long txId) {
        return Headers.headersBuilder().put(FileVersion.FILE_VERSION, new FileVersion(txId)).headers();
    }

    @Override
    protected int compareHeaders(Headers lhs, Headers rhs) {
        return CountsTracker.compare(lhs.get(FileVersion.FILE_VERSION), rhs.get(FileVersion.FILE_VERSION));
    }

    static int compare(FileVersion lhs, FileVersion rhs) {
        int cmp = Long.compare(lhs.txId, rhs.txId);
        if (cmp == 0) {
            cmp = Long.compare(lhs.minorVersion, rhs.minorVersion);
        }
        return cmp;
    }

    @Override
    protected void writeKey(CountsKey key, WritableBuffer buffer) {
        key.accept(new KeyFormat(buffer), 0L, 0L);
    }

    @Override
    protected CountsKey readKey(ReadableBuffer key) throws UnknownKey {
        return KeyFormat.readKey(key);
    }

    @Override
    protected boolean include(CountsKey countsKey, ReadableBuffer value) {
        return !value.allZeroes();
    }

    @Override
    protected void updateHeaders(Headers.Builder headers, long version) {
        headers.put(FileVersion.FILE_VERSION, headers.get(FileVersion.FILE_VERSION).update(version));
    }

    @Override
    protected long version(Headers headers) {
        return headers == null ? 1L : headers.get(FileVersion.FILE_VERSION).txId;
    }

    @Override
    protected void writeFormatSpecifier(WritableBuffer formatSpecifier) {
        formatSpecifier.put(0, FORMAT);
    }

    private class DelegatingVisitor
    extends AbstractKeyValueStore.Visitor
    implements MetadataVisitor {
        private final CountsVisitor visitor;

        DelegatingVisitor(CountsVisitor visitor) {
            super(CountsTracker.this);
            this.visitor = visitor;
        }

        protected boolean visitKeyValuePair(CountsKey key, ReadableBuffer value) {
            key.accept(this.visitor, value.getLong(0), value.getLong(8));
            return true;
        }

        @Override
        public void visitMetadata(File path, Headers headers, int entryCount) {
            if (this.visitor instanceof MetadataVisitor) {
                ((MetadataVisitor)((Object)this.visitor)).visitMetadata(path, headers, entryCount);
            }
        }

        @Override
        protected boolean visitUnknownKey(UnknownKey exception, ReadableBuffer key, ReadableBuffer value) {
            if (this.visitor instanceof UnknownKey.Visitor) {
                return ((UnknownKey.Visitor)((Object)this.visitor)).visitUnknownKey(key, value);
            }
            return super.visitUnknownKey(exception, key, value);
        }
    }
}

