/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;

class DuplicatePropertyRemover {
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final PropertyRecord otherPropertyRecord;

    DuplicatePropertyRemover(NodeStore nodeStore, PropertyStore propertyStore) {
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
        this.otherPropertyRecord = propertyStore.newRecord();
    }

    public void fixUpPropertyLinksAroundUnusedRecord(NodeRecord nodeRecord, PropertyRecord duplicateRecord) {
        assert (!duplicateRecord.iterator().hasNext());
        long headProp = nodeRecord.getNextProp();
        if (duplicateRecord.getId() == headProp) {
            nodeRecord.setNextProp(duplicateRecord.getNextProp());
            this.nodeStore.updateRecord(nodeRecord);
        }
        long previousRecordId = duplicateRecord.getPrevProp();
        long nextRecordId = duplicateRecord.getNextProp();
        if (previousRecordId != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            this.propertyStore.getRecord(previousRecordId, this.otherPropertyRecord, RecordLoad.NORMAL);
            this.otherPropertyRecord.setNextProp(nextRecordId);
            this.propertyStore.updateRecord(this.otherPropertyRecord);
        }
        if (nextRecordId != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.propertyStore.getRecord(nextRecordId, this.otherPropertyRecord, RecordLoad.NORMAL);
            this.otherPropertyRecord.setPrevProp(previousRecordId);
            this.propertyStore.updateRecord(this.otherPropertyRecord);
        }
    }
}

