/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.LongBitsManipulator;

public class IdFieldManipulator {
    private static final LongBitsManipulator MANIPULATOR = new LongBitsManipulator(35, 29);
    private static final long EMPTY_FIELD = MANIPULATOR.template(true, false);

    private IdFieldManipulator() {
    }

    public static long setId(long field, long id) {
        return MANIPULATOR.set(field, 0, id);
    }

    public static long getId(long field) {
        return MANIPULATOR.get(field, 0);
    }

    public static long changeCount(long field, int diff) {
        return IdFieldManipulator.setCount(field, IdFieldManipulator.getCount(field) + diff);
    }

    public static int getCount(long field) {
        return (int)MANIPULATOR.get(field, 1);
    }

    public static long setCount(long field, int count) {
        return MANIPULATOR.set(field, 1, count);
    }

    public static long cleanId(long field) {
        return MANIPULATOR.clear(field, 0, true);
    }

    public static long emptyField() {
        return EMPTY_FIELD;
    }
}

