/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.progress;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.neo4j.helpers.progress.Indicator;
import org.neo4j.helpers.progress.ProgressListener;

final class Aggregator {
    private final Map<ProgressListener, ProgressListener.MultiPartProgressListener.State> states = new HashMap<ProgressListener, ProgressListener.MultiPartProgressListener.State>();
    private final Indicator indicator;
    private volatile long progress;
    private volatile int last;
    private static final AtomicLongFieldUpdater<Aggregator> PROGRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(Aggregator.class, "progress");
    private static final AtomicIntegerFieldUpdater<Aggregator> LAST_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Aggregator.class, "last");
    private long totalCount;

    Aggregator(Indicator indicator) {
        this.indicator = indicator;
    }

    synchronized void add(ProgressListener progress, long totalCount) {
        this.states.put(progress, ProgressListener.MultiPartProgressListener.State.INIT);
        this.totalCount += totalCount;
    }

    synchronized void initialize() {
        this.indicator.startProcess(this.totalCount);
        if (this.states.isEmpty()) {
            this.indicator.progress(0, this.indicator.reportResolution());
            this.indicator.completeProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(long delta) {
        long progress = PROGRESS_UPDATER.addAndGet(this, delta);
        int current = (int)(progress * (long)this.indicator.reportResolution() / this.totalCount);
        int last = this.last;
        while (current > last) {
            if (LAST_UPDATER.compareAndSet(this, last, current)) {
                Aggregator aggregator = this;
                synchronized (aggregator) {
                    this.indicator.progress(last, current);
                }
            }
            last = this.last;
        }
    }

    synchronized void start(ProgressListener.MultiPartProgressListener part) {
        if (this.states.put(part, ProgressListener.MultiPartProgressListener.State.LIVE) == ProgressListener.MultiPartProgressListener.State.INIT) {
            this.indicator.startPart(part.part, part.totalCount);
        }
    }

    synchronized void complete(ProgressListener.MultiPartProgressListener part) {
        if (this.states.remove(part) != null) {
            this.indicator.completePart(part.part);
            if (this.states.isEmpty()) {
                this.indicator.completeProcess();
            }
        }
    }

    synchronized void signalFailure(Throwable e) {
        this.indicator.failure(e);
    }
}

