/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.explicitindex.AutoIndexing;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.GraphPropertiesProxy;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.coreapi.AutoIndexerFacade;
import org.neo4j.kernel.impl.coreapi.IndexManagerImpl;
import org.neo4j.kernel.impl.coreapi.IndexProviderImpl;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PlaceboTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.coreapi.ReadOnlyIndexFacade;
import org.neo4j.kernel.impl.coreapi.ReadOnlyRelationshipIndexFacade;
import org.neo4j.kernel.impl.coreapi.RelationshipAutoIndexerFacade;
import org.neo4j.kernel.impl.coreapi.TopLevelTransaction;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class GraphDatabaseFacade
implements GraphDatabaseAPI,
EmbeddedProxySPI {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private Schema schema;
    private Supplier<IndexManager> indexManager;
    private ThreadToStatementContextBridge statementContext;
    protected EditionModule editionModule;
    private SPI spi;
    private TransactionalContextFactory contextFactory;
    private Config config;
    private RelationshipTypeTokenHolder relationshipTypeTokenHolder;

    public void init(EditionModule editionModule, SPI spi, Guard guard, ThreadToStatementContextBridge txBridge, Config config, RelationshipTypeTokenHolder relationshipTypeTokenHolder) {
        this.editionModule = editionModule;
        this.spi = spi;
        this.config = config;
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.schema = new SchemaImpl(() -> txBridge.getKernelTransactionBoundToThisThread(true));
        this.statementContext = txBridge;
        this.indexManager = Suppliers.lazySingleton(() -> {
            IndexProviderImpl idxProvider = new IndexProviderImpl(this, () -> txBridge.getKernelTransactionBoundToThisThread(true));
            AutoIndexerFacade<Node> nodeAutoIndexer = new AutoIndexerFacade<Node>(() -> new ReadOnlyIndexFacade<Node>((ReadableIndex<Node>)idxProvider.getOrCreateNodeIndex("node_auto_index", null)), spi.autoIndexing().nodes());
            RelationshipAutoIndexerFacade relAutoIndexer = new RelationshipAutoIndexerFacade(() -> new ReadOnlyRelationshipIndexFacade(idxProvider.getOrCreateRelationshipIndex("relationship_auto_index", null)), spi.autoIndexing().relationships());
            return new IndexManagerImpl(() -> txBridge.getKernelTransactionBoundToThisThread(true), idxProvider, nodeAutoIndexer, relAutoIndexer);
        });
        this.contextFactory = Neo4jTransactionalContextFactory.create(spi, guard, txBridge, locker);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node createNode() {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        try (Statement ignore = transaction.acquireStatement();){
            NodeProxy nodeProxy = this.newNodeProxy(transaction.dataWrite().nodeCreate());
            return nodeProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long createNodeId() {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        try (Statement ignore = transaction.acquireStatement();){
            Long l = transaction.dataWrite().nodeCreate();
            return l;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node createNode(Label ... labels) {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        try (Statement ignore = transaction.acquireStatement();){
            Write write = transaction.dataWrite();
            long nodeId = write.nodeCreate();
            for (Label label : labels) {
                int labelId = transaction.tokenWrite().labelGetOrCreateForName(label.name());
                try {
                    write.nodeAddLabel(nodeId, labelId);
                }
                catch (EntityNotFoundException e) {
                    throw new NotFoundException("No node with id " + nodeId + " found.", (Throwable)e);
                }
            }
            NodeProxy nodeProxy = this.newNodeProxy(nodeId);
            return nodeProxy;
        }
        catch (ConstraintValidationException e) {
            throw new ConstraintViolationException("Unable to add label.", (Throwable)e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        catch (KernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    public Node getNodeById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Node %d not found", id), (Throwable)new EntityNotFoundException(EntityType.NODE, id));
        }
        KernelTransaction ktx = this.statementContext.getKernelTransactionBoundToThisThread(true);
        this.assertTransactionOpen(ktx);
        try (Statement ignore = ktx.acquireStatement();){
            if (!ktx.dataRead().nodeExists(id)) {
                throw new NotFoundException(String.format("Node %d not found", id), (Throwable)new EntityNotFoundException(EntityType.NODE, id));
            }
            NodeProxy nodeProxy = this.newNodeProxy(id);
            return nodeProxy;
        }
    }

    public Relationship getRelationshipById(long id) {
        if (id < 0L) {
            throw new NotFoundException(String.format("Relationship %d not found", id), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, id));
        }
        KernelTransaction ktx = this.statementContext.getKernelTransactionBoundToThisThread(true);
        this.assertTransactionOpen(ktx);
        try (Statement ignore = this.statementContext.get();){
            if (!ktx.dataRead().relationshipExists(id)) {
                throw new NotFoundException(String.format("Relationship %d not found", id), (Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, id));
            }
            RelationshipProxy relationshipProxy = this.newRelationshipProxy(id);
            return relationshipProxy;
        }
    }

    public IndexManager index() {
        return this.indexManager.get();
    }

    public Schema schema() {
        this.assertTransactionOpen();
        return this.schema;
    }

    public boolean isAvailable(long timeoutMillis) {
        return this.spi.databaseIsAvailable(timeoutMillis);
    }

    public void shutdown() {
        this.spi.shutdown();
    }

    public Transaction beginTx() {
        return this.beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);
    }

    public Transaction beginTx(long timeout, TimeUnit unit) {
        return this.beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED, timeout, unit);
    }

    @Override
    public InternalTransaction beginTransaction(Transaction.Type type, LoginContext loginContext) {
        return this.beginTransactionInternal(type, loginContext, this.config.get(GraphDatabaseSettings.transaction_timeout).toMillis());
    }

    @Override
    public InternalTransaction beginTransaction(Transaction.Type type, LoginContext loginContext, long timeout, TimeUnit unit) {
        return this.beginTransactionInternal(type, loginContext, unit.toMillis(timeout));
    }

    public Result execute(String query) throws QueryExecutionException {
        return this.execute(query, Collections.emptyMap());
    }

    public Result execute(String query, long timeout, TimeUnit unit) throws QueryExecutionException {
        return this.execute(query, Collections.emptyMap(), timeout, unit);
    }

    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        InternalTransaction transaction = this.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
        return this.execute(transaction, query, ValueUtils.asMapValue(parameters));
    }

    public Result execute(String query, Map<String, Object> parameters, long timeout, TimeUnit unit) throws QueryExecutionException {
        InternalTransaction transaction = this.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED, timeout, unit);
        return this.execute(transaction, query, ValueUtils.asMapValue(parameters));
    }

    public Result execute(InternalTransaction transaction, String query, MapValue parameters) throws QueryExecutionException {
        TransactionalContext context = this.contextFactory.newContext(ClientConnectionInfo.EMBEDDED_CONNECTION, transaction, query, parameters);
        return this.spi.executeQuery(query, parameters, context);
    }

    public ResourceIterable<Node> getAllNodes() {
        KernelTransaction ktx = this.statementContext.getKernelTransactionBoundToThisThread(true);
        this.assertTransactionOpen(ktx);
        return () -> {
            final Statement statement = ktx.acquireStatement();
            final NodeCursor cursor = ktx.cursors().allocateNodeCursor();
            ktx.dataRead().allNodesScan(cursor);
            return new PrefetchingResourceIterator<Node>(){

                protected Node fetchNextOrNull() {
                    if (cursor.next()) {
                        return GraphDatabaseFacade.this.newNodeProxy(cursor.nodeReference());
                    }
                    this.close();
                    return null;
                }

                public void close() {
                    cursor.close();
                    statement.close();
                }
            };
        };
    }

    public ResourceIterable<Relationship> getAllRelationships() {
        KernelTransaction ktx = this.statementContext.getKernelTransactionBoundToThisThread(true);
        this.assertTransactionOpen(ktx);
        return () -> {
            final Statement statement = ktx.acquireStatement();
            final RelationshipScanCursor cursor = ktx.cursors().allocateRelationshipScanCursor();
            ktx.dataRead().allRelationshipsScan(cursor);
            return new PrefetchingResourceIterator<Relationship>(){

                protected Relationship fetchNextOrNull() {
                    if (cursor.next()) {
                        return GraphDatabaseFacade.this.newRelationshipProxy(cursor.relationshipReference(), cursor.sourceNodeReference(), cursor.type(), cursor.targetNodeReference());
                    }
                    this.close();
                    return null;
                }

                public void close() {
                    cursor.close();
                    statement.close();
                }
            };
        };
    }

    public ResourceIterable<Label> getAllLabelsInUse() {
        return this.allInUse(TokenAccess.LABELS);
    }

    public ResourceIterable<RelationshipType> getAllRelationshipTypesInUse() {
        return this.allInUse(TokenAccess.RELATIONSHIP_TYPES);
    }

    private <T> ResourceIterable<T> allInUse(TokenAccess<T> tokens) {
        this.assertTransactionOpen();
        return () -> tokens.inUse(this.statementContext.getTopLevelTransactionBoundToThisThread(true));
    }

    public ResourceIterable<Label> getAllLabels() {
        return this.all(TokenAccess.LABELS);
    }

    public ResourceIterable<RelationshipType> getAllRelationshipTypes() {
        return this.all(TokenAccess.RELATIONSHIP_TYPES);
    }

    public ResourceIterable<String> getAllPropertyKeys() {
        return this.all(TokenAccess.PROPERTY_KEYS);
    }

    private <T> ResourceIterable<T> all(TokenAccess<T> tokens) {
        this.assertTransactionOpen();
        return () -> {
            KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
            return tokens.all(transaction);
        };
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        this.spi.registerKernelEventHandler(handler);
        return handler;
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.spi.registerTransactionEventHandler(handler);
        return handler;
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        this.spi.unregisterKernelEventHandler(handler);
        return handler;
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.spi.unregisterTransactionEventHandler(handler);
        return handler;
    }

    public ResourceIterator<Node> findNodes(Label myLabel, String key, Object value) {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(myLabel.name());
        int propertyId = tokenRead.propertyKey(key);
        return this.nodesByLabelAndProperty(transaction, labelId, (IndexQuery)IndexQuery.exact((int)propertyId, (Object)Values.of((Object)value)));
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2) {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        return this.nodesByLabelAndProperties(transaction, labelId, IndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1)), IndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2)));
    }

    public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        return this.nodesByLabelAndProperties(transaction, labelId, IndexQuery.exact((int)tokenRead.propertyKey(key1), (Object)Values.of((Object)value1)), IndexQuery.exact((int)tokenRead.propertyKey(key2), (Object)Values.of((Object)value2)), IndexQuery.exact((int)tokenRead.propertyKey(key3), (Object)Values.of((Object)value3)));
    }

    public ResourceIterator<Node> findNodes(Label label, Map<String, Object> propertyValues) {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(label.name());
        IndexQuery.ExactPredicate[] queries = new IndexQuery.ExactPredicate[propertyValues.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
            queries[i++] = IndexQuery.exact((int)tokenRead.propertyKey(entry.getKey()), (Object)Values.of((Object)entry.getValue()));
        }
        return this.nodesByLabelAndProperties(transaction, labelId, queries);
    }

    public ResourceIterator<Node> findNodes(Label myLabel, String key, String value, StringSearchMode searchMode) {
        IndexQuery.StringPrefixPredicate query;
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        TokenRead tokenRead = transaction.tokenRead();
        int labelId = tokenRead.nodeLabel(myLabel.name());
        int propertyId = tokenRead.propertyKey(key);
        switch (searchMode) {
            case EXACT: {
                query = IndexQuery.exact((int)propertyId, (Object)Values.stringValue((String)value));
                break;
            }
            case PREFIX: {
                query = IndexQuery.stringPrefix((int)propertyId, (String)value);
                break;
            }
            case SUFFIX: {
                query = IndexQuery.stringSuffix((int)propertyId, (String)value);
                break;
            }
            case CONTAINS: {
                query = IndexQuery.stringContains((int)propertyId, (String)value);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown string search mode: " + searchMode);
            }
        }
        return this.nodesByLabelAndProperty(transaction, labelId, (IndexQuery)query);
    }

    public Node findNode(Label myLabel, String key, Object value) {
        try (ResourceIterator<Node> iterator = this.findNodes(myLabel, key, value);){
            if (!iterator.hasNext()) {
                Node node = null;
                return node;
            }
            Node node = (Node)iterator.next();
            if (iterator.hasNext()) {
                throw new MultipleFoundException(String.format("Found multiple nodes with label: '%s', property name: '%s' and property value: '%s' while only one was expected.", myLabel, key, value));
            }
            Node node2 = node;
            return node2;
        }
    }

    public ResourceIterator<Node> findNodes(Label myLabel) {
        return this.allNodesWithLabel(myLabel);
    }

    private InternalTransaction beginTransactionInternal(Transaction.Type type, LoginContext loginContext, long timeoutMillis) {
        if (this.statementContext.hasTransaction()) {
            return new PlaceboTransaction(this.statementContext.getKernelTransactionBoundToThisThread(true));
        }
        return new TopLevelTransaction(this.spi.beginTransaction(type, loginContext, timeoutMillis), this.statementContext);
    }

    private ResourceIterator<Node> nodesByLabelAndProperty(KernelTransaction transaction, int labelId, IndexQuery query) {
        Statement statement = transaction.acquireStatement();
        Read read = transaction.dataRead();
        if (query.propertyKeyId() == -1 || labelId == -1) {
            statement.close();
            return Iterators.emptyResourceIterator();
        }
        CapableIndexReference index = transaction.schemaRead().index(labelId, new int[]{query.propertyKeyId()});
        if (index != CapableIndexReference.NO_INDEX) {
            try {
                NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor();
                read.nodeIndexSeek((IndexReference)index, cursor, IndexOrder.NONE, new IndexQuery[]{query});
                return new NodeCursorResourceIterator<NodeValueIndexCursor>(cursor, statement, this::newNodeProxy);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getNodesByLabelAndPropertyWithoutIndex(statement, labelId, query);
    }

    private ResourceIterator<Node> nodesByLabelAndProperties(KernelTransaction transaction, int labelId, IndexQuery.ExactPredicate ... queries) {
        Statement statement = transaction.acquireStatement();
        Read read = transaction.dataRead();
        if (this.isInvalidQuery(labelId, (IndexQuery[])queries)) {
            statement.close();
            return Iterators.emptyResourceIterator();
        }
        int[] propertyIds = this.getPropertyIds((IndexQuery[])queries);
        IndexReference index = this.findMatchingIndex(transaction, labelId, propertyIds);
        if (index != CapableIndexReference.NO_INDEX) {
            try {
                NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor();
                read.nodeIndexSeek(index, cursor, IndexOrder.NONE, this.getReorderedIndexQueries(index.properties(), (IndexQuery[])queries));
                return new NodeCursorResourceIterator<NodeValueIndexCursor>(cursor, statement, this::newNodeProxy);
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
        return this.getNodesByLabelAndPropertyWithoutIndex(statement, labelId, (IndexQuery[])queries);
    }

    private IndexReference findMatchingIndex(KernelTransaction transaction, int labelId, int[] propertyIds) {
        CapableIndexReference index = transaction.schemaRead().index(labelId, propertyIds);
        if (index != CapableIndexReference.NO_INDEX) {
            return index;
        }
        Arrays.sort(propertyIds);
        this.assertNoDuplicates(propertyIds, transaction.tokenRead());
        int[] workingCopy = new int[propertyIds.length];
        Iterator indexes = transaction.schemaRead().indexesGetForLabel(labelId);
        while (indexes.hasNext()) {
            index = (IndexReference)indexes.next();
            int[] original = index.properties();
            if (!this.hasSamePropertyIds(original, workingCopy, propertyIds)) continue;
            return index;
        }
        return CapableIndexReference.NO_INDEX;
    }

    private IndexQuery[] getReorderedIndexQueries(int[] indexPropertyIds, IndexQuery[] queries) {
        IndexQuery[] orderedQueries = new IndexQuery[queries.length];
        block0: for (int i = 0; i < indexPropertyIds.length; ++i) {
            int propertyKeyId = indexPropertyIds[i];
            for (IndexQuery query : queries) {
                if (query.propertyKeyId() != propertyKeyId) continue;
                orderedQueries[i] = query;
                continue block0;
            }
        }
        return orderedQueries;
    }

    private boolean hasSamePropertyIds(int[] original, int[] workingCopy, int[] propertyIds) {
        if (original.length == propertyIds.length) {
            System.arraycopy(original, 0, workingCopy, 0, original.length);
            Arrays.sort(workingCopy);
            return Arrays.equals(propertyIds, workingCopy);
        }
        return false;
    }

    private int[] getPropertyIds(IndexQuery[] queries) {
        int[] propertyIds = new int[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            propertyIds[i] = queries[i].propertyKeyId();
        }
        return propertyIds;
    }

    private boolean isInvalidQuery(int labelId, IndexQuery[] queries) {
        boolean invalidQuery = labelId == -1;
        for (IndexQuery query : queries) {
            int propertyKeyId = query.propertyKeyId();
            invalidQuery = invalidQuery || propertyKeyId == -1;
        }
        return invalidQuery;
    }

    private void assertNoDuplicates(int[] propertyIds, TokenRead tokenRead) {
        int prev = propertyIds[0];
        for (int i = 1; i < propertyIds.length; ++i) {
            int curr = propertyIds[i];
            if (curr == prev) {
                SilentTokenNameLookup tokenLookup = new SilentTokenNameLookup(tokenRead);
                throw new IllegalArgumentException(String.format("Provided two queries for property %s. Only one query per property key can be performed", tokenLookup.propertyKeyGetName(curr)));
            }
            prev = curr;
        }
    }

    private ResourceIterator<Node> getNodesByLabelAndPropertyWithoutIndex(Statement statement, int labelId, IndexQuery ... queries) {
        KernelTransaction transaction = this.statementContext.getKernelTransactionBoundToThisThread(true);
        NodeLabelIndexCursor nodeLabelCursor = transaction.cursors().allocateNodeLabelIndexCursor();
        NodeCursor nodeCursor = transaction.cursors().allocateNodeCursor();
        PropertyCursor propertyCursor = transaction.cursors().allocatePropertyCursor();
        transaction.dataRead().nodeLabelScan(labelId, nodeLabelCursor);
        return new NodeLabelPropertyIterator(transaction.dataRead(), nodeLabelCursor, nodeCursor, propertyCursor, statement, this::newNodeProxy, queries);
    }

    private ResourceIterator<Node> allNodesWithLabel(Label myLabel) {
        KernelTransaction ktx = this.statementContext.getKernelTransactionBoundToThisThread(true);
        Statement statement = ktx.acquireStatement();
        int labelId = ktx.tokenRead().nodeLabel(myLabel.name());
        if (labelId == -1) {
            statement.close();
            return Iterators.emptyResourceIterator();
        }
        NodeLabelIndexCursor cursor = ktx.cursors().allocateNodeLabelIndexCursor();
        ktx.dataRead().nodeLabelScan(labelId, cursor);
        return new NodeCursorResourceIterator<NodeLabelIndexCursor>(cursor, statement, this::newNodeProxy);
    }

    public TraversalDescription traversalDescription() {
        return new MonoDirectionalTraversalDescription(this.statementContext);
    }

    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return new BidirectionalTraversalDescriptionImpl(this.statementContext);
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.spi.resolver();
    }

    @Override
    public StoreId storeId() {
        return this.spi.storeId();
    }

    @Override
    public URL validateURLAccess(URL url) throws URLAccessValidationError {
        return this.spi.validateURLAccess(url);
    }

    @Override
    public File getStoreDir() {
        return this.spi.storeDir();
    }

    public String toString() {
        return this.spi.name() + " [" + this.getStoreDir() + "]";
    }

    @Override
    public Statement statement() {
        return this.statementContext.get();
    }

    @Override
    public KernelTransaction kernelTransaction() {
        return this.statementContext.getKernelTransactionBoundToThisThread(true);
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this;
    }

    @Override
    public void assertInUnterminatedTransaction() {
        this.statementContext.assertInUnterminatedTransaction();
    }

    @Override
    public void failTransaction() {
        this.statementContext.getKernelTransactionBoundToThisThread(true).failure();
    }

    @Override
    public RelationshipProxy newRelationshipProxy(long id) {
        return new RelationshipProxy(this, id);
    }

    @Override
    public RelationshipProxy newRelationshipProxy(long id, long startNodeId, int typeId, long endNodeId) {
        return new RelationshipProxy(this, id, startNodeId, typeId, endNodeId);
    }

    @Override
    public NodeProxy newNodeProxy(long nodeId) {
        return new NodeProxy(this, nodeId);
    }

    @Override
    public RelationshipType getRelationshipTypeById(int type) {
        try {
            return (RelationshipType)this.relationshipTypeTokenHolder.getTokenById(type);
        }
        catch (TokenNotFoundException e) {
            throw new IllegalStateException("Kernel API returned non-existent relationship type: " + type);
        }
    }

    @Override
    public int getRelationshipTypeIdByName(String typeName) {
        return this.relationshipTypeTokenHolder.getIdByName(typeName);
    }

    @Override
    public GraphPropertiesProxy newGraphPropertiesProxy() {
        return new GraphPropertiesProxy(this);
    }

    private void assertTransactionOpen() {
        this.assertTransactionOpen(this.statementContext.getKernelTransactionBoundToThisThread(true));
    }

    private void assertTransactionOpen(KernelTransaction transaction) {
        if (transaction.isTerminated()) {
            Status terminationReason = (Status)transaction.getReasonIfTerminated().orElse(Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
    }

    private static interface NodeFactory {
        public NodeProxy make(long var1);
    }

    private static abstract class PrefetchingNodeResourceIterator
    implements ResourceIterator<Node> {
        private final Statement statement;
        private final NodeFactory nodeFactory;
        private long next;
        private boolean closed;
        private static final long NOT_INITIALIZED = -2L;
        protected static final long NO_ID = -1L;

        PrefetchingNodeResourceIterator(Statement statement, NodeFactory nodeFactory) {
            this.statement = statement;
            this.nodeFactory = nodeFactory;
            this.next = -2L;
        }

        public boolean hasNext() {
            if (this.next == -2L) {
                this.next = this.fetchNext();
            }
            return this.next != -1L;
        }

        public Node next() {
            if (!this.hasNext()) {
                this.close();
                throw new NoSuchElementException();
            }
            NodeProxy nodeProxy = this.nodeFactory.make(this.next);
            this.next = this.fetchNext();
            return nodeProxy;
        }

        public void close() {
            if (!this.closed) {
                this.next = -1L;
                this.closeResources(this.statement);
                this.closed = true;
            }
        }

        abstract long fetchNext();

        abstract void closeResources(Statement var1);
    }

    private static final class NodeCursorResourceIterator<CURSOR extends NodeIndexCursor>
    extends PrefetchingNodeResourceIterator {
        private final CURSOR cursor;

        NodeCursorResourceIterator(CURSOR cursor, Statement statement, NodeFactory nodeFactory) {
            super(statement, nodeFactory);
            this.cursor = cursor;
        }

        @Override
        long fetchNext() {
            if (this.cursor.next()) {
                return this.cursor.nodeReference();
            }
            this.close();
            return -1L;
        }

        @Override
        void closeResources(Statement statement) {
            IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{statement, this.cursor});
        }
    }

    private static class NodeLabelPropertyIterator
    extends PrefetchingNodeResourceIterator {
        private final Read read;
        private final NodeLabelIndexCursor nodeLabelCursor;
        private final NodeCursor nodeCursor;
        private final PropertyCursor propertyCursor;
        private final IndexQuery[] queries;

        NodeLabelPropertyIterator(Read read, NodeLabelIndexCursor nodeLabelCursor, NodeCursor nodeCursor, PropertyCursor propertyCursor, Statement statement, NodeFactory nodeFactory, IndexQuery ... queries) {
            super(statement, nodeFactory);
            this.read = read;
            this.nodeLabelCursor = nodeLabelCursor;
            this.nodeCursor = nodeCursor;
            this.propertyCursor = propertyCursor;
            this.queries = queries;
        }

        @Override
        protected long fetchNext() {
            boolean hasNext;
            while ((hasNext = this.nodeLabelCursor.next()) && !this.hasPropertiesWithValues()) {
            }
            if (hasNext) {
                return this.nodeLabelCursor.nodeReference();
            }
            this.close();
            return -1L;
        }

        @Override
        void closeResources(Statement statement) {
            IOUtils.closeAllSilently((AutoCloseable[])new AutoCloseable[]{statement, this.nodeLabelCursor, this.nodeCursor, this.propertyCursor});
        }

        private boolean hasPropertiesWithValues() {
            int targetCount = this.queries.length;
            this.read.singleNode(this.nodeLabelCursor.nodeReference(), this.nodeCursor);
            if (this.nodeCursor.next()) {
                this.nodeCursor.properties(this.propertyCursor);
                while (this.propertyCursor.next()) {
                    for (IndexQuery query : this.queries) {
                        if (this.propertyCursor.propertyKey() != query.propertyKeyId()) continue;
                        if (query.acceptsValueAt(this.propertyCursor)) {
                            if (--targetCount != 0) continue;
                            return true;
                        }
                        return false;
                    }
                }
            }
            return false;
        }
    }

    public static interface SPI {
        public boolean databaseIsAvailable(long var1);

        public DependencyResolver resolver();

        public StoreId storeId();

        public File storeDir();

        public String name();

        public void shutdown();

        public KernelTransaction beginTransaction(Transaction.Type var1, LoginContext var2, long var3);

        public Result executeQuery(String var1, Map<String, Object> var2, TransactionalContext var3);

        public Result executeQuery(String var1, MapValue var2, TransactionalContext var3);

        public AutoIndexing autoIndexing();

        public void registerKernelEventHandler(KernelEventHandler var1);

        public void unregisterKernelEventHandler(KernelEventHandler var1);

        public <T> void registerTransactionEventHandler(TransactionEventHandler<T> var1);

        public <T> void unregisterTransactionEventHandler(TransactionEventHandler<T> var1);

        public URL validateURLAccess(URL var1) throws URLAccessValidationError;

        public GraphDatabaseQueryService queryService();

        public Kernel kernel();
    }
}

