/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NumberLayoutNonUnique;
import org.neo4j.kernel.impl.index.schema.NumberLayoutUnique;
import org.neo4j.kernel.impl.index.schema.NumberSchemaIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NumberSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NumberSchemaKey;
import org.neo4j.values.storable.ValueCategory;

public class NumberIndexProvider
extends NativeIndexProvider<NumberSchemaKey, NativeSchemaValue> {
    public static final String KEY = "native";
    public static final IndexProvider.Descriptor NATIVE_PROVIDER_DESCRIPTOR = new IndexProvider.Descriptor("native", "1.0");
    static final IndexCapability CAPABILITY = new NumberIndexCapability();

    public NumberIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(NATIVE_PROVIDER_DESCRIPTOR, 0, directoryStructure, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly);
    }

    @Override
    Layout<NumberSchemaKey, NativeSchemaValue> layout(SchemaIndexDescriptor descriptor) {
        switch (descriptor.type()) {
            case GENERAL: {
                return new NumberLayoutNonUnique();
            }
            case UNIQUE: {
                return new NumberLayoutUnique();
            }
        }
        throw new IllegalArgumentException("Unknown index type " + (Object)((Object)descriptor.type()));
    }

    @Override
    protected IndexPopulator newIndexPopulator(File storeFile, Layout<NumberSchemaKey, NativeSchemaValue> layout, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) {
        return new NumberSchemaIndexPopulator(this.pageCache, this.fs, storeFile, layout, this.monitor, descriptor, indexId, samplingConfig);
    }

    @Override
    protected IndexAccessor newIndexAccessor(File storeFile, Layout<NumberSchemaKey, NativeSchemaValue> layout, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) throws IOException {
        return new NumberSchemaIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor, indexId, samplingConfig);
    }

    @Override
    public IndexCapability getCapability(SchemaIndexDescriptor schemaIndexDescriptor) {
        return CAPABILITY;
    }

    private static class NumberIndexCapability
    implements IndexCapability {
        private NumberIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            if (this.support(valueCategories)) {
                return ORDER_ASC;
            }
            return ORDER_NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            if (this.support(valueCategories)) {
                return IndexValueCapability.YES;
            }
            if (this.singleWildcard(valueCategories)) {
                return IndexValueCapability.PARTIAL;
            }
            return IndexValueCapability.NO;
        }

        private boolean support(ValueCategory[] valueCategories) {
            return valueCategories.length == 1 && valueCategories[0] == ValueCategory.NUMBER;
        }
    }
}

