/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;

class FusionIndexUpdater
extends FusionIndexBase<IndexUpdater>
implements IndexUpdater {
    FusionIndexUpdater(IndexUpdater[] updaters, FusionIndexProvider.Selector selector) {
        super(updaters, selector);
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                ((IndexUpdater)this.selector.select(this.instances, update.values())).process(update);
                break;
            }
            case CHANGED: {
                IndexUpdater from = (IndexUpdater)this.selector.select(this.instances, update.beforeValues());
                IndexUpdater to = (IndexUpdater)this.selector.select(this.instances, update.values());
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            case REMOVED: {
                ((IndexUpdater)this.selector.select(this.instances, update.values())).process(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        try {
            FusionIndexUpdater.forAll(IndexUpdater::close, this.instances);
        }
        catch (IOException | RuntimeException | IndexEntryConflictException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

