/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;

public class ReadOnlyLocks
implements Locks {
    private static final ReadOnlyClient READ_ONLY_CLIENT = new ReadOnlyClient();

    @Override
    public Locks.Client newClient() {
        return READ_ONLY_CLIENT;
    }

    @Override
    public void accept(Locks.Visitor visitor) {
    }

    @Override
    public void close() {
    }

    private static class ReadOnlyClient
    extends NoOpClient {
        private ReadOnlyClient() {
        }

        @Override
        public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
            this.fail();
        }

        @Override
        public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
            this.fail();
        }

        @Override
        public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
            this.fail();
            return false;
        }

        @Override
        public boolean trySharedLock(ResourceType resourceType, long resourceId) {
            this.fail();
            return false;
        }

        @Override
        public void releaseShared(ResourceType resourceType, long ... resourceIds) {
            this.fail();
        }

        @Override
        public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
            this.fail();
        }

        private void fail() {
            throw new IllegalStateException("Cannot acquire locks in read only mode");
        }
    }
}

