/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecureRandom;
import java.util.Random;

public final class StoreId
implements Externalizable {
    public static final StoreId DEFAULT = new StoreId(-1L, -1L, -1L, -1L, -1L);
    private static final Random r = new SecureRandom();
    private long creationTime;
    private long randomId;
    private long storeVersion;
    private long upgradeTime;
    private long upgradeId;

    public StoreId() {
    }

    public StoreId(long storeVersion) {
        long currentTimeMillis = System.currentTimeMillis();
        long randomLong = r.nextLong();
        this.storeVersion = storeVersion;
        this.creationTime = currentTimeMillis;
        this.randomId = randomLong;
        this.upgradeTime = currentTimeMillis;
        this.upgradeId = randomLong;
    }

    public StoreId(long creationTime, long randomId, long storeVersion, long upgradeTime, long upgradeId) {
        this.creationTime = creationTime;
        this.randomId = randomId;
        this.storeVersion = storeVersion;
        this.upgradeTime = upgradeTime;
        this.upgradeId = upgradeId;
    }

    public static StoreId from(ObjectInput in) throws IOException {
        StoreId storeId = new StoreId();
        storeId.readExternal(in);
        return storeId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public long getUpgradeTime() {
        return this.upgradeTime;
    }

    public long getUpgradeId() {
        return this.upgradeId;
    }

    public long getStoreVersion() {
        return this.storeVersion;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.creationTime);
        out.writeLong(this.randomId);
        out.writeLong(this.storeVersion);
        out.writeLong(this.upgradeTime);
        out.writeLong(this.upgradeId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.creationTime = in.readLong();
        this.randomId = in.readLong();
        this.storeVersion = in.readLong();
        this.upgradeTime = in.readLong();
        this.upgradeId = in.readLong();
    }

    public boolean equalsByUpgradeId(StoreId other) {
        return StoreId.internalEqual(this.upgradeTime, other.upgradeTime) && StoreId.internalEqual(this.upgradeId, other.upgradeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreId other = (StoreId)o;
        return StoreId.internalEqual(this.creationTime, other.creationTime) && StoreId.internalEqual(this.randomId, other.randomId);
    }

    public int hashCode() {
        return 31 * (int)(this.creationTime ^ this.creationTime >>> 32) + (int)(this.randomId ^ this.randomId >>> 32);
    }

    public String toString() {
        return "StoreId{creationTime=" + this.creationTime + ", randomId=" + this.randomId + ", storeVersion=" + this.storeVersion + ", upgradeTime=" + this.upgradeTime + ", upgradeId=" + this.upgradeId + '}';
    }

    private static boolean internalEqual(long first, long second) {
        return first == second || first == -1L || second == -1L;
    }
}

