/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.storemigration.participant.StoreScanChunk;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;

abstract class StoreScanAsInputIterator<RECORD extends AbstractBaseRecord>
implements InputIterator {
    private final RecordStore<RECORD> store;
    private final int batchSize;
    private final long highId;
    private long id;

    StoreScanAsInputIterator(RecordStore<RECORD> store) {
        this.store = store;
        this.batchSize = store.getRecordsPerPage() * 10;
        this.highId = store.getHighId();
    }

    RecordCursor<RECORD> createCursor() {
        return this.store.newRecordCursor(this.store.newRecord()).acquire(0L, RecordLoad.CHECK);
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized boolean next(InputChunk chunk) {
        if (this.id >= this.highId) {
            return false;
        }
        long startId = this.id;
        this.id = Long.min(this.highId, startId + (long)this.batchSize);
        ((StoreScanChunk)chunk).initialize(startId, this.id);
        return true;
    }
}

