/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;

public class ReadOnlyLogVersionRepository
implements LogVersionRepository {
    private final long logVersion;
    private volatile boolean incrementVersionCalled;

    public ReadOnlyLogVersionRepository(PageCache pageCache, File storeDir) throws IOException {
        File neoStore = new File(storeDir, "neostore");
        this.logVersion = this.readLogVersion(pageCache, neoStore);
    }

    private long readLogVersion(PageCache pageCache, File neoStore) throws IOException {
        try {
            return MetaDataStore.getRecord(pageCache, neoStore, MetaDataStore.Position.LOG_VERSION);
        }
        catch (NoSuchFileException ignore) {
            return 0L;
        }
    }

    @Override
    public long getCurrentLogVersion() {
        if (this.incrementVersionCalled) {
            throw new IllegalStateException("Read-only log version repository has observed a call to incrementVersion, which indicates that it's been shut down");
        }
        return this.logVersion;
    }

    @Override
    public void setCurrentLogVersion(long version) {
        throw new UnsupportedOperationException("Can't set current log version in read only version repository.");
    }

    @Override
    public long incrementAndGetVersion() {
        if (this.incrementVersionCalled) {
            throw new IllegalStateException("Read-only log version repository only allows to call incrementVersion once, during shutdown");
        }
        this.incrementVersionCalled = true;
        return this.logVersion;
    }
}

