/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdRangeIterator;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public class BatchingIdGetter
extends PrimitiveLongCollections.PrimitiveLongBaseIterator
implements IdSequence {
    private final IdSequence source;
    private IdRangeIterator batch;
    private final int batchSize;

    public BatchingIdGetter(RecordStore<? extends AbstractBaseRecord> source) {
        this(source, source.getRecordsPerPage());
    }

    public BatchingIdGetter(RecordStore<? extends AbstractBaseRecord> source, int batchSize) {
        this.source = source;
        this.batchSize = batchSize;
    }

    protected boolean fetchNext() {
        return this.next(this.nextId());
    }

    @Override
    public long nextId() {
        long id;
        if (this.batch == null || (id = this.batch.nextId()) == -1L) {
            IdRange idRange = this.source.nextIdBatch(this.batchSize);
            while (IdValidator.hasReservedIdInRange(idRange.getRangeStart(), idRange.getRangeStart() + (long)idRange.getRangeLength())) {
                idRange = this.source.nextIdBatch(this.batchSize);
            }
            this.batch = new IdRangeIterator(idRange);
            id = this.batch.nextId();
        }
        return id;
    }

    @Override
    public IdRange nextIdBatch(int size) {
        throw new UnsupportedOperationException();
    }
}

