/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Numbers;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.memory.GlobalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.ChunkedNumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapIntArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.PageCachedNumberArrayFactory;

public interface NumberArrayFactory {
    public static final NumberArrayFactory HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base) {
            return new HeapIntArray(Numbers.safeCastLongToInt((long)length), defaultValue, base);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base) {
            return new HeapLongArray(Numbers.safeCastLongToInt((long)length), defaultValue, base);
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base) {
            return new HeapByteArray(Numbers.safeCastLongToInt((long)length), defaultValue, base);
        }

        public String toString() {
            return "HEAP";
        }
    };
    public static final NumberArrayFactory OFF_HEAP = new Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base) {
            return new OffHeapIntArray(length, defaultValue, base, (MemoryAllocationTracker)GlobalMemoryTracker.INSTANCE);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base) {
            return new OffHeapLongArray(length, defaultValue, base, (MemoryAllocationTracker)GlobalMemoryTracker.INSTANCE);
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base) {
            return new OffHeapByteArray(length, defaultValue, base, (MemoryAllocationTracker)GlobalMemoryTracker.INSTANCE);
        }

        public String toString() {
            return "OFF_HEAP";
        }
    };
    public static final NumberArrayFactory CHUNKED_FIXED_SIZE = new ChunkedNumberArrayFactory();
    public static final NumberArrayFactory AUTO_WITHOUT_PAGECACHE = new Auto(OFF_HEAP, HEAP, CHUNKED_FIXED_SIZE);

    public static NumberArrayFactory auto(PageCache pageCache, File dir, boolean allowHeapAllocation) {
        PageCachedNumberArrayFactory pagedArrayFactory = new PageCachedNumberArrayFactory(pageCache, dir);
        ChunkedNumberArrayFactory chunkedArrayFactory = new ChunkedNumberArrayFactory(NumberArrayFactory.allocationAlternatives(allowHeapAllocation, pagedArrayFactory));
        return new Auto(NumberArrayFactory.allocationAlternatives(allowHeapAllocation, chunkedArrayFactory));
    }

    public static NumberArrayFactory[] allocationAlternatives(boolean allowHeapAllocation, NumberArrayFactory ... additional) {
        ArrayList<NumberArrayFactory> result = new ArrayList<NumberArrayFactory>(Collections.singletonList(OFF_HEAP));
        if (allowHeapAllocation) {
            result.add(HEAP);
        }
        result.addAll(Arrays.asList(additional));
        return result.toArray(new NumberArrayFactory[result.size()]);
    }

    default public IntArray newIntArray(long length, int defaultValue) {
        return this.newIntArray(length, defaultValue, 0L);
    }

    public IntArray newIntArray(long var1, int var3, long var4);

    public IntArray newDynamicIntArray(long var1, int var3);

    default public LongArray newLongArray(long length, long defaultValue) {
        return this.newLongArray(length, defaultValue, 0L);
    }

    public LongArray newLongArray(long var1, long var3, long var5);

    public LongArray newDynamicLongArray(long var1, long var3);

    default public ByteArray newByteArray(long length, byte[] defaultValue) {
        return this.newByteArray(length, defaultValue, 0L);
    }

    public ByteArray newByteArray(long var1, byte[] var3, long var4);

    public ByteArray newDynamicByteArray(long var1, byte[] var3);

    public static abstract class Adapter
    implements NumberArrayFactory {
        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue) {
            return new DynamicIntArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue) {
            return new DynamicLongArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }

        @Override
        public ByteArray newDynamicByteArray(long chunkSize, byte[] defaultValue) {
            return new DynamicByteArray((NumberArrayFactory)this, chunkSize, defaultValue);
        }
    }

    public static class Auto
    extends Adapter {
        private final NumberArrayFactory[] candidates;

        public Auto(NumberArrayFactory ... candidates) {
            this.candidates = candidates;
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base) {
            return this.tryAllocate(length, 8, f -> f.newLongArray(length, defaultValue, base));
        }

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base) {
            return this.tryAllocate(length, 4, f -> f.newIntArray(length, defaultValue, base));
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base) {
            return this.tryAllocate(length, defaultValue.length, f -> f.newByteArray(length, defaultValue, base));
        }

        private <T extends NumberArray<? extends T>> T tryAllocate(long length, int itemSize, Function<NumberArrayFactory, T> allocator) {
            OutOfMemoryError error = null;
            for (NumberArrayFactory candidate : this.candidates) {
                try {
                    try {
                        return (T)((NumberArray)allocator.apply(candidate));
                    }
                    catch (ArithmeticException e) {
                        throw new OutOfMemoryError(e.getMessage());
                    }
                }
                catch (OutOfMemoryError e) {
                    if (error == null) {
                        error = e;
                        continue;
                    }
                    e.addSuppressed(error);
                    error = e;
                }
            }
            throw this.error(length, itemSize, error);
        }

        private OutOfMemoryError error(long length, int itemSize, OutOfMemoryError error) {
            return (OutOfMemoryError)Exceptions.withMessage((Throwable)error, (String)String.format("%s: Not enough memory available for allocating %s, tried %s", error.getMessage(), Format.bytes(length * (long)itemSize), Arrays.toString(this.candidates)));
        }
    }
}

