/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;

public class DeadlockDetectedException
extends TransientTransactionFailureException
implements Status.HasStatus {
    public DeadlockDetectedException(String message) {
        super(message, null);
    }

    public DeadlockDetectedException(String message, Throwable cause) {
        super("Don't panic.\n\nA deadlock scenario has been detected and avoided. This means that two or more transactions, which were holding locks, were wanting to await locks held by one another, which would have resulted in a deadlock between these transactions. This exception was thrown instead of ending up in that deadlock.\n\nSee the deadlock section in the Neo4j Java developer reference for how to avoid this: https://neo4j.com/docs/java-reference/4.0/transaction-management/deadlocks/#transactions-deadlocks\n\nDetails: '" + message + "'.", cause);
    }

    public Status status() {
        return Status.Transaction.DeadlockDetected;
    }
}

