/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.dbms;

import org.neo4j.collection.RawIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.procedure.BasicContext;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public class TransactionalDbmsOperations
implements DbmsOperations {
    private final GlobalProcedures globalProcedures;

    public TransactionalDbmsOperations(GlobalProcedures globalProcedures) {
        this.globalProcedures = globalProcedures;
    }

    @Override
    public RawIterator<AnyValue[], ProcedureException> procedureCallDbms(int id, AnyValue[] input, InternalTransaction transaction, DependencyResolver dependencyResolver, SecurityContext securityContext, ResourceTracker resourceTracker, ValueMapper<Object> valueMapper) throws ProcedureException {
        Context ctx = TransactionalDbmsOperations.createContext(transaction, securityContext, dependencyResolver, valueMapper);
        return this.globalProcedures.callProcedure(ctx, id, input, resourceTracker);
    }

    private static Context createContext(InternalTransaction transaction, SecurityContext securityContext, DependencyResolver dependencyResolver, ValueMapper<Object> valueMapper) {
        return BasicContext.buildContext(dependencyResolver, valueMapper).withTransaction(transaction).withSecurityContext(securityContext).context();
    }
}

