/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Objects;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.SinglePropertyConstraintDefinition;

abstract class RelationshipConstraintDefinition
extends SinglePropertyConstraintDefinition {
    protected final RelationshipType relationshipType;

    RelationshipConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, RelationshipType relationshipType, String propertyKey) {
        super(actions, constraint, propertyKey);
        this.relationshipType = Objects.requireNonNull(relationshipType);
    }

    public Label getLabel() {
        this.assertInUnterminatedTransaction();
        throw new IllegalStateException("Constraint is associated with relationships");
    }

    public RelationshipType getRelationshipType() {
        this.assertInUnterminatedTransaction();
        return this.relationshipType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipConstraintDefinition that = (RelationshipConstraintDefinition)o;
        return this.relationshipType.name().equals(that.relationshipType.name()) && this.propertyKey.equals(that.propertyKey);
    }

    @Override
    public int hashCode() {
        return 31 * this.relationshipType.name().hashCode() + this.propertyKey.hashCode();
    }
}

