/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.function.Consumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesReader;
import org.neo4j.kernel.impl.index.schema.NativeIndex;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.NodePropertyAccessor;

public abstract class NativeIndexAccessor<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndex<KEY, VALUE>
implements IndexAccessor {
    private final NativeIndexUpdater<KEY, VALUE> singleUpdater;
    final NativeIndexHeaderWriter headerWriter;

    NativeIndexAccessor(PageCache pageCache, FileSystemAbstraction fs, IndexFiles indexFiles, IndexLayout<KEY, VALUE> layout, IndexProvider.Monitor monitor, IndexDescriptor descriptor, Consumer<PageCursor> additionalHeaderWriter, boolean readOnly) {
        super(pageCache, fs, indexFiles, layout, monitor, descriptor, readOnly);
        this.singleUpdater = new NativeIndexUpdater<NativeIndexKey, Object>((NativeIndexKey)((Object)layout.newKey()), layout.newValue());
        this.headerWriter = new NativeIndexHeaderWriter(1, additionalHeaderWriter);
    }

    public void drop() {
        this.closeTree();
        this.indexFiles.clear();
    }

    public NativeIndexUpdater<KEY, VALUE> newUpdater(IndexUpdateMode mode) {
        this.assertOpen();
        try {
            return this.singleUpdater.initialize(this.tree.writer());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void force(IOLimiter ioLimiter) {
        this.tree.checkpoint(ioLimiter);
    }

    public void refresh() {
    }

    public void close() {
        this.closeTree();
    }

    public boolean isDirty() {
        return this.tree.wasDirtyOnStartup();
    }

    public abstract IndexReader newReader();

    public BoundedIterable<Long> newAllEntriesReader(long fromIdInclusive, long toIdExclusive) {
        return new NativeAllEntriesReader(this.tree, this.layout, fromIdInclusive, toIdExclusive);
    }

    public ResourceIterator<File> snapshotFiles() {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.indexFiles.getStoreFile()));
    }

    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
    }

    public long estimateNumberOfEntries() {
        try {
            return this.tree.estimateNumberOfEntriesInTree();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (TreeInconsistencyException e) {
            return -1L;
        }
    }
}

