/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

abstract class NativeIndexSingleValueKey<SELF extends NativeIndexSingleValueKey<SELF>>
extends NativeIndexKey<SELF> {
    NativeIndexSingleValueKey() {
    }

    @Override
    void assertValidValue(int stateSlot, Value value) {
        Preconditions.requireExactlyZero((int)stateSlot);
        this.assertCorrectType(value);
    }

    @Override
    void writeValue(int stateSlot, Value value, NativeIndexKey.Inclusion inclusion) {
        value.writeTo((ValueWriter)this);
    }

    @Override
    final void initValueAsLowest(int stateSlot, ValueGroup valueGroup) {
        this.initValueAsLowest(valueGroup);
    }

    abstract void initValueAsLowest(ValueGroup var1);

    @Override
    final void initValueAsHighest(int stateSlot, ValueGroup valueGroup) {
        this.initValueAsHighest(valueGroup);
    }

    abstract void initValueAsHighest(ValueGroup var1);

    abstract Value assertCorrectType(Value var1);

    abstract Value asValue();

    @Override
    Value[] asValues() {
        return (Value[])Iterators.array((Object[])new Value[]{this.asValue()});
    }

    void from(Value value) {
        this.assertCorrectType(value);
        value.writeTo((ValueWriter)this);
    }

    @Override
    int numberOfStateSlots() {
        return 1;
    }
}

