/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Arrays;
import java.util.function.Function;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;

public abstract class FusionIndexBase<T> {
    static final Function<Value, ValueCategory> CATEGORY_OF = value -> value.valueGroup().category();
    final SlotSelector slotSelector;
    final InstanceSelector<T> instanceSelector;

    FusionIndexBase(SlotSelector slotSelector, InstanceSelector<T> instanceSelector) {
        this.slotSelector = slotSelector;
        this.instanceSelector = instanceSelector;
    }

    public static <T, E extends Exception> void forAll(ThrowingConsumer<T, E> consumer, Iterable<T> subjects) throws E {
        Iterables.safeForAll(consumer, subjects);
    }

    public static <T, E extends Exception> void forAll(ThrowingConsumer<T, E> consumer, T[] subjects) throws E {
        FusionIndexBase.forAll(consumer, Arrays.asList(subjects));
    }

    public static <T extends ConsistencyCheckable> boolean consistencyCheck(Iterable<T> checkables, ReporterFactory reporterFactory) {
        boolean result = true;
        for (ConsistencyCheckable part : checkables) {
            result &= part.consistencyCheck(reporterFactory);
        }
        return result;
    }
}

