/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.stream.Stream;
import org.neo4j.internal.kernel.api.exceptions.FrozenLocksException;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.lock.LockTracer;

public class FrozenStatementLocks
implements StatementLocks {
    private final StatementLocks realStatementLocks;
    private int nesting;

    public FrozenStatementLocks(StatementLocks realStatementLocks) {
        this.realStatementLocks = realStatementLocks;
        this.nesting = 1;
    }

    public StatementLocks getRealStatementLocks() {
        return this.realStatementLocks;
    }

    @Override
    public void initialize(LeaseClient leaseClient) {
        this.realStatementLocks.initialize(leaseClient);
    }

    @Override
    public Locks.Client pessimistic() {
        throw new FrozenLocksException(this.realStatementLocks.pessimistic().getLockSessionId());
    }

    @Override
    public Locks.Client optimistic() {
        throw new FrozenLocksException(this.realStatementLocks.pessimistic().getLockSessionId());
    }

    @Override
    public void prepareForCommit(LockTracer lockTracer) {
        throw new FrozenLocksException(this.realStatementLocks.pessimistic().getLockSessionId());
    }

    @Override
    public void stop() {
        this.realStatementLocks.stop();
    }

    @Override
    public void close() {
        throw new FrozenLocksException(this.realStatementLocks.pessimistic().getLockSessionId());
    }

    @Override
    public Stream<? extends ActiveLock> activeLocks() {
        return this.realStatementLocks.activeLocks();
    }

    @Override
    public long activeLockCount() {
        return this.realStatementLocks.activeLockCount();
    }

    public void freeze() {
        ++this.nesting;
    }

    public boolean thaw() {
        --this.nesting;
        return this.nesting == 0;
    }
}

