/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

final class RelationshipReferenceEncoding
extends Enum<RelationshipReferenceEncoding> {
    public static final /* enum */ RelationshipReferenceEncoding NONE = new RelationshipReferenceEncoding(0L);
    public static final /* enum */ RelationshipReferenceEncoding DENSE = new RelationshipReferenceEncoding(1L);
    public static final /* enum */ RelationshipReferenceEncoding SELECTION = new RelationshipReferenceEncoding(2L);
    public static final /* enum */ RelationshipReferenceEncoding DENSE_SELECTION = new RelationshipReferenceEncoding(3L);
    public static final /* enum */ RelationshipReferenceEncoding NO_OUTGOING_OF_TYPE = new RelationshipReferenceEncoding(4L);
    public static final /* enum */ RelationshipReferenceEncoding NO_INCOMING_OF_TYPE = new RelationshipReferenceEncoding(5L);
    public static final /* enum */ RelationshipReferenceEncoding NO_LOOPS_OF_TYPE = new RelationshipReferenceEncoding(6L);
    private static final RelationshipReferenceEncoding[] ENCODINGS;
    static final long FLAG_MARKER = Long.MIN_VALUE;
    static final long FLAG_MASK = 0x7000000000000000L;
    static final long FLAGS = -1152921504606846976L;
    final long id;
    final long bits;
    private static final /* synthetic */ RelationshipReferenceEncoding[] $VALUES;

    public static RelationshipReferenceEncoding[] values() {
        return (RelationshipReferenceEncoding[])$VALUES.clone();
    }

    public static RelationshipReferenceEncoding valueOf(String name) {
        return Enum.valueOf(RelationshipReferenceEncoding.class, name);
    }

    private RelationshipReferenceEncoding(long id) {
        this.id = id;
        this.bits = id << 60;
    }

    static RelationshipReferenceEncoding parseEncoding(long reference) {
        if (reference == -1L) {
            return NONE;
        }
        return ENCODINGS[RelationshipReferenceEncoding.encodingId(reference)];
    }

    private static int encodingId(long reference) {
        return (int)((reference & 0x7000000000000000L) >> 60);
    }

    static long encodeDense(long reference) {
        return reference | RelationshipReferenceEncoding.DENSE.bits | Long.MIN_VALUE;
    }

    static long encodeSelection(long reference) {
        return reference | RelationshipReferenceEncoding.SELECTION.bits | Long.MIN_VALUE;
    }

    static long encodeDenseSelection(long reference) {
        return reference | RelationshipReferenceEncoding.DENSE_SELECTION.bits | Long.MIN_VALUE;
    }

    static long encodeNoOutgoing(int type) {
        return (long)type | RelationshipReferenceEncoding.NO_OUTGOING_OF_TYPE.bits | Long.MIN_VALUE;
    }

    static long encodeNoIncoming(int type) {
        return (long)type | RelationshipReferenceEncoding.NO_INCOMING_OF_TYPE.bits | Long.MIN_VALUE;
    }

    static long encodeNoLoops(int type) {
        return (long)type | RelationshipReferenceEncoding.NO_LOOPS_OF_TYPE.bits | Long.MIN_VALUE;
    }

    static long clearEncoding(long reference) {
        assert (reference != -1L);
        return reference & 0xFFFFFFFFFFFFFFFL;
    }

    static {
        $VALUES = new RelationshipReferenceEncoding[]{NONE, DENSE, SELECTION, DENSE_SELECTION, NO_OUTGOING_OF_TYPE, NO_INCOMING_OF_TYPE, NO_LOOPS_OF_TYPE};
        ENCODINGS = RelationshipReferenceEncoding.values();
    }
}

