/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query.clientconnection;

import java.net.SocketAddress;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;

public class BoltConnectionInfo
extends ClientConnectionInfo {
    private final String connectionId;
    private final String clientName;
    private final SocketAddress clientAddress;
    private final SocketAddress serverAddress;

    public BoltConnectionInfo(String connectionId, String clientName, SocketAddress clientAddress, SocketAddress serverAddress) {
        this.connectionId = connectionId;
        this.clientName = clientName;
        this.clientAddress = clientAddress;
        this.serverAddress = serverAddress;
    }

    public String asConnectionDetails() {
        return String.format("bolt-session\tbolt\t%s\t\tclient%s\tserver%s>", this.clientName, this.clientAddress, this.serverAddress);
    }

    public String protocol() {
        return "bolt";
    }

    public String connectionId() {
        return this.connectionId;
    }

    public String clientAddress() {
        return org.neo4j.configuration.helpers.SocketAddress.format((SocketAddress)this.clientAddress);
    }

    public String requestURI() {
        return org.neo4j.configuration.helpers.SocketAddress.format((SocketAddress)this.serverAddress);
    }
}

