/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.impl.scheduler.GroupedDaemonThreadFactory;
import org.neo4j.kernel.impl.scheduler.ThreadPool;
import org.neo4j.kernel.impl.scheduler.ThreadPoolManager;
import org.neo4j.kernel.impl.scheduler.TimeBasedTaskScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.resources.Profiler;
import org.neo4j.scheduler.ActiveGroup;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.SchedulerThreadFactoryFactory;
import org.neo4j.time.SystemNanoClock;

public class CentralJobScheduler
extends LifecycleAdapter
implements JobScheduler,
AutoCloseable {
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private final TimeBasedTaskScheduler scheduler;
    private final Thread schedulerThread;
    private final TopLevelGroup topLevelGroup = new TopLevelGroup();
    private final ThreadPoolManager pools = new ThreadPoolManager(this.topLevelGroup);
    private final ConcurrentHashMap<Group, ThreadPool.ThreadPoolParameters> extraParameters;
    private volatile boolean started;

    protected CentralJobScheduler(SystemNanoClock clock) {
        this.scheduler = new TimeBasedTaskScheduler(clock, this.pools);
        this.extraParameters = new ConcurrentHashMap();
        GroupedDaemonThreadFactory threadFactory = new GroupedDaemonThreadFactory(Group.TASK_SCHEDULER, this.topLevelGroup);
        this.schedulerThread = threadFactory.newThread(this.scheduler);
        int priority = 6;
        this.schedulerThread.setPriority(priority);
    }

    public void setTopLevelGroupName(String name) {
        try {
            this.topLevelGroup.setName(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setParallelism(Group group, int parallelism) {
        this.pools.assumeNotStarted(group);
        this.extraParameters.computeIfAbsent((Group)group, (Function<Group, ThreadPool.ThreadPoolParameters>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setParallelism$0(org.neo4j.scheduler.Group ), (Lorg/neo4j/scheduler/Group;)Lorg/neo4j/kernel/impl/scheduler/ThreadPool$ThreadPoolParameters;)()).desiredParallelism = parallelism;
    }

    public void setThreadFactory(Group group, SchedulerThreadFactoryFactory threadFactory) {
        this.pools.assumeNotStarted(group);
        this.extraParameters.computeIfAbsent((Group)group, (Function<Group, ThreadPool.ThreadPoolParameters>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setThreadFactory$1(org.neo4j.scheduler.Group ), (Lorg/neo4j/scheduler/Group;)Lorg/neo4j/kernel/impl/scheduler/ThreadPool$ThreadPoolParameters;)()).providedThreadFactory = threadFactory;
    }

    public void init() {
        if (!this.started) {
            this.schedulerThread.start();
            this.started = true;
        }
    }

    public Executor executor(Group group) {
        return this.getThreadPool(group).getExecutorService();
    }

    public ThreadFactory threadFactory(Group group) {
        return this.getThreadPool(group).getThreadFactory();
    }

    private ThreadPool getThreadPool(Group group) {
        return this.pools.getThreadPool(group, this.extraParameters.get(group));
    }

    public JobHandle schedule(Group group, Runnable job) {
        if (!this.started) {
            throw new RejectedExecutionException("Scheduler is not started");
        }
        return this.getThreadPool(group).submit(job);
    }

    public JobHandle scheduleRecurring(Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        return this.scheduleRecurring(group, runnable, 0L, period, timeUnit);
    }

    public JobHandle scheduleRecurring(Group group, Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        return this.scheduler.submit(group, runnable, unit.toNanos(initialDelay), unit.toNanos(period));
    }

    public Stream<ActiveGroup> activeGroups() {
        ArrayList groups = new ArrayList();
        this.pools.forEachStarted((group, pool) -> {
            int activeThreadCount = pool.activeThreadCount();
            if (activeThreadCount > 0) {
                groups.add(new ActiveGroup(group, activeThreadCount));
            }
        });
        return groups.stream();
    }

    public void profileGroup(Group group, Profiler profiler) {
        if (!this.pools.isStarted(group)) {
            return;
        }
        this.getThreadPool(group).activeThreads().forEach(arg_0 -> ((Profiler)profiler).profile(arg_0));
    }

    public JobHandle schedule(Group group, Runnable runnable, long initialDelay, TimeUnit unit) {
        return this.scheduler.submit(group, runnable, unit.toNanos(initialDelay), 0L);
    }

    public void shutdown() {
        this.started = false;
        InterruptedException exception = this.shutDownScheduler();
        if ((exception = (InterruptedException)Exceptions.chain((Throwable)exception, (Throwable)this.pools.shutDownAll())) != null) {
            throw new RuntimeException("Unable to shut down job scheduler properly.", exception);
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private InterruptedException shutDownScheduler() {
        this.scheduler.stop();
        try {
            this.schedulerThread.join();
        }
        catch (InterruptedException e) {
            return e;
        }
        return null;
    }

    private static /* synthetic */ ThreadPool.ThreadPoolParameters lambda$setThreadFactory$1(Group g) {
        return new ThreadPool.ThreadPoolParameters();
    }

    private static /* synthetic */ ThreadPool.ThreadPoolParameters lambda$setParallelism$0(Group g) {
        return new ThreadPool.ThreadPoolParameters();
    }

    private static class TopLevelGroup
    extends ThreadGroup {
        TopLevelGroup() {
            super("Neo4j-" + INSTANCE_COUNTER.incrementAndGet());
        }

        public void setName(String name) throws Exception {
            Field field = ThreadGroup.class.getDeclaredField("name");
            field.setAccessible(true);
            field.set(this, name);
        }
    }
}

