/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

import org.neo4j.scheduler.FailedJobRun;

public class FailedJobRunsStore
{
    private final int sizeLimit;
    private final Deque<FailedJobRun> failedJobs;

    public FailedJobRunsStore( int sizeLimit )
    {
        this.sizeLimit = sizeLimit;
        failedJobs = new ArrayDeque<>( sizeLimit );
    }

    public synchronized void add( FailedJobRun jobFailure )
    {
        if ( failedJobs.size() + 1 == sizeLimit )
        {
            failedJobs.removeFirst();
        }

        failedJobs.add( jobFailure );
    }

    public synchronized List<FailedJobRun> getFailedJobRuns()
    {
        return new ArrayList<>( failedJobs );
    }
}
