/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.BtreeKey;
import org.neo4j.kernel.impl.index.schema.CompositeBtreeKey;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;

class GenericLayout
extends IndexLayout<BtreeKey> {
    private final int numberOfSlots;
    private final IndexSpecificSpaceFillingCurveSettings spatialSettings;

    GenericLayout(int numberOfSlots, IndexSpecificSpaceFillingCurveSettings spatialSettings) {
        super(false, Layout.namedIdentifier((String)"NSIL", (int)numberOfSlots), 0, 5);
        this.numberOfSlots = numberOfSlots;
        this.spatialSettings = spatialSettings;
    }

    public BtreeKey newKey() {
        return this.numberOfSlots == 1 ? new BtreeKey(this.spatialSettings) : new CompositeBtreeKey(this.numberOfSlots, this.spatialSettings);
    }

    public BtreeKey copyKey(BtreeKey key, BtreeKey into) {
        into.copyFrom(key);
        return into;
    }

    public int keySize(BtreeKey key) {
        return key.size();
    }

    public void writeKey(PageCursor cursor, BtreeKey key) {
        key.put(cursor);
    }

    public void readKey(PageCursor cursor, BtreeKey into, int keySize) {
        into.get(cursor, keySize);
    }

    public void minimalSplitter(BtreeKey left, BtreeKey right, BtreeKey into) {
        right.minimalSplitter(left, right, into);
    }

    IndexSpecificSpaceFillingCurveSettings getSpaceFillingCurveSettings() {
        return this.spatialSettings;
    }

    public void initializeAsLowest(BtreeKey key) {
        key.initValuesAsLowest();
    }

    public void initializeAsHighest(BtreeKey key) {
        key.initValuesAsHighest();
    }
}

