/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.event;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.event.LabelEntryView;
import org.neo4j.kernel.internal.event.NodePropertyEntryView;
import org.neo4j.kernel.internal.event.RelationshipPropertyEntryView;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class TxStateTransactionDataSnapshot
implements TransactionData,
AutoCloseable {
    private final ReadableTransactionState state;
    private final StorageReader store;
    private final KernelTransaction transaction;
    private final HeapTrackingArrayList<PropertyEntry<Node>> assignedNodeProperties;
    private final HeapTrackingArrayList<PropertyEntry<Relationship>> assignedRelationshipProperties;
    private final HeapTrackingArrayList<LabelEntry> assignedLabels;
    private final HeapTrackingArrayList<PropertyEntry<Node>> removedNodeProperties;
    private final HeapTrackingArrayList<PropertyEntry<Relationship>> removedRelationshipProperties;
    private final HeapTrackingArrayList<LabelEntry> removedLabels;
    private final MutableLongObjectMap<RelationshipEntity> relationshipsReadFromStore;
    private final StorageRelationshipScanCursor relationship;
    private final InternalTransaction internalTransaction;
    private final MemoryTracker memoryTracker;

    TxStateTransactionDataSnapshot(ReadableTransactionState state, StorageReader storageReader, KernelTransaction transaction) {
        this.state = state;
        this.store = storageReader;
        this.transaction = transaction;
        this.internalTransaction = transaction.internalTransaction();
        this.memoryTracker = transaction.memoryTracker();
        this.relationship = storageReader.allocateRelationshipScanCursor(transaction.cursorContext(), transaction.storeCursors());
        this.relationshipsReadFromStore = HeapTrackingCollections.newLongObjectMap((MemoryTracker)this.memoryTracker);
        this.removedLabels = HeapTrackingCollections.newArrayList((MemoryTracker)this.memoryTracker);
        this.removedRelationshipProperties = HeapTrackingCollections.newArrayList((MemoryTracker)this.memoryTracker);
        this.removedNodeProperties = HeapTrackingCollections.newArrayList((MemoryTracker)this.memoryTracker);
        this.assignedLabels = HeapTrackingCollections.newArrayList((MemoryTracker)this.memoryTracker);
        this.assignedRelationshipProperties = HeapTrackingCollections.newArrayList((MemoryTracker)this.memoryTracker);
        this.assignedNodeProperties = HeapTrackingCollections.newArrayList((MemoryTracker)this.memoryTracker);
        this.takeSnapshot(this.memoryTracker);
    }

    public Iterable<Node> createdNodes() {
        return this.map2Nodes((LongIterable)this.state.addedAndRemovedNodes().getAdded());
    }

    public Iterable<Node> deletedNodes() {
        return this.map2Nodes((LongIterable)this.state.addedAndRemovedNodes().getRemoved());
    }

    public Iterable<Relationship> createdRelationships() {
        return this.map2Rels((LongIterable)this.state.addedAndRemovedRelationships().getAdded());
    }

    public Iterable<Relationship> deletedRelationships() {
        return this.map2Rels((LongIterable)this.state.addedAndRemovedRelationships().getRemoved());
    }

    public boolean isDeleted(Node node) {
        return this.state.nodeIsDeletedInThisTx(node.getId());
    }

    public boolean isDeleted(Relationship relationship) {
        return this.state.relationshipIsDeletedInThisTx(relationship.getId());
    }

    public Iterable<PropertyEntry<Node>> assignedNodeProperties() {
        return this.assignedNodeProperties;
    }

    public Iterable<PropertyEntry<Node>> removedNodeProperties() {
        return this.removedNodeProperties;
    }

    public Iterable<PropertyEntry<Relationship>> assignedRelationshipProperties() {
        return this.assignedRelationshipProperties;
    }

    public Iterable<PropertyEntry<Relationship>> removedRelationshipProperties() {
        return this.removedRelationshipProperties;
    }

    public String username() {
        return this.transaction.securityContext().subject().executingUser();
    }

    public Map<String, Object> metaData() {
        return this.transaction.getMetaData();
    }

    public Iterable<LabelEntry> removedLabels() {
        return this.removedLabels;
    }

    public Iterable<LabelEntry> assignedLabels() {
        return this.assignedLabels;
    }

    public long getTransactionId() {
        return this.transaction.getTransactionId();
    }

    public long getCommitTime() {
        return this.transaction.getCommitTime();
    }

    private void takeSnapshot(MemoryTracker memoryTracker) {
        CursorContext cursorContext = this.transaction.cursorContext();
        StoreCursors storeCursors = this.transaction.storeCursors();
        try (StorageNodeCursor node = this.store.allocateNodeCursor(cursorContext, storeCursors);
             StoragePropertyCursor properties = this.store.allocatePropertyCursor(cursorContext, storeCursors, memoryTracker);){
            TokenRead tokenRead = this.transaction.tokenRead();
            this.snapshotRemovedNodes(memoryTracker, node, properties, tokenRead);
            this.snapshotRemovedRelationships(memoryTracker, properties, tokenRead);
            this.snapshotModifiedNodes(memoryTracker, node, properties, tokenRead);
            this.snapshotModifiedRelationships(memoryTracker, properties, tokenRead);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("An entity that does not exist was modified.", e);
        }
    }

    private void snapshotModifiedRelationships(MemoryTracker memoryTracker, StoragePropertyCursor properties, TokenRead tokenRead) throws PropertyKeyIdNotFoundKernelException {
        for (RelationshipState relState : this.state.modifiedRelationships()) {
            Relationship relationship = this.relationship(relState.getId());
            for (StorageProperty property : relState.addedAndChangedProperties()) {
                this.assignedRelationshipProperties.add((Object)TxStateTransactionDataSnapshot.createRelationshipPropertyEntryView(memoryTracker, tokenRead, relationship, property.propertyKeyId(), property.value(), this.committedValue(relState, property.propertyKeyId(), this.relationship, properties)));
            }
            relState.removedProperties().each((IntProcedure & Serializable)id -> {
                try {
                    RelationshipPropertyEntryView entryView = TxStateTransactionDataSnapshot.createRelationshipPropertyEntryView(memoryTracker, tokenRead, relationship, id, null, this.committedValue(relState, id, this.relationship, properties));
                    this.removedRelationshipProperties.add((Object)entryView);
                }
                catch (PropertyKeyIdNotFoundKernelException e) {
                    throw new IllegalStateException("Not existing properties was modified for relationship " + relState.getId(), e);
                }
            });
        }
    }

    private void snapshotModifiedNodes(MemoryTracker memoryTracker, StorageNodeCursor node, StoragePropertyCursor properties, TokenRead tokenRead) throws PropertyKeyIdNotFoundKernelException {
        for (NodeState nodeState : this.state.modifiedNodes()) {
            Iterator added = nodeState.addedAndChangedProperties().iterator();
            long nodeId = nodeState.getId();
            while (added.hasNext()) {
                StorageProperty property = (StorageProperty)added.next();
                NodePropertyEntryView entryView = this.createNodePropertyEntryView(memoryTracker, tokenRead, nodeId, property.propertyKeyId(), property.value(), this.committedValue(nodeState, property.propertyKeyId(), node, properties));
                this.assignedNodeProperties.add((Object)entryView);
            }
            nodeState.removedProperties().each((IntProcedure & Serializable)id -> {
                try {
                    this.removedNodeProperties.add((Object)this.createNodePropertyEntryView(memoryTracker, tokenRead, nodeId, id, null, this.committedValue(nodeState, id, node, properties)));
                }
                catch (PropertyKeyIdNotFoundKernelException e) {
                    throw new IllegalStateException("Not existing node properties was modified for node " + nodeId, e);
                }
            });
            LongDiffSets labels = nodeState.labelDiffSets();
            this.addLabelEntriesTo(nodeId, labels.getAdded(), this.assignedLabels);
            this.addLabelEntriesTo(nodeId, labels.getRemoved(), this.removedLabels);
        }
    }

    private void snapshotRemovedRelationships(MemoryTracker memoryTracker, StoragePropertyCursor properties, TokenRead tokenRead) {
        this.state.addedAndRemovedRelationships().getRemoved().each((LongProcedure & Serializable)relId -> {
            Relationship relationship = this.relationship(relId);
            this.relationship.single(relId);
            if (this.relationship.next()) {
                this.relationship.properties(properties, PropertySelection.ALL_PROPERTIES);
                while (properties.next()) {
                    try {
                        this.removedRelationshipProperties.add((Object)TxStateTransactionDataSnapshot.createRelationshipPropertyEntryView(memoryTracker, tokenRead, relationship, properties.propertyKey(), null, properties.propertyValue()));
                    }
                    catch (PropertyKeyIdNotFoundKernelException e) {
                        throw new IllegalStateException("Not existing node properties was modified for relationship " + relId, e);
                    }
                }
            }
        });
    }

    private void snapshotRemovedNodes(MemoryTracker memoryTracker, StorageNodeCursor node, StoragePropertyCursor properties, TokenRead tokenRead) {
        this.state.addedAndRemovedNodes().getRemoved().each((LongProcedure & Serializable)nodeId -> {
            node.single(nodeId);
            if (node.next()) {
                node.properties(properties, PropertySelection.ALL_PROPERTIES);
                while (properties.next()) {
                    try {
                        this.removedNodeProperties.add((Object)this.createNodePropertyEntryView(memoryTracker, tokenRead, nodeId, properties.propertyKey(), null, properties.propertyValue()));
                    }
                    catch (PropertyKeyIdNotFoundKernelException e) {
                        throw new IllegalStateException("Not existing properties was modified for node " + nodeId, e);
                    }
                }
                for (long labelId : node.labels()) {
                    try {
                        this.removedLabels.add((Object)this.createLabelView(memoryTracker, tokenRead, nodeId, labelId));
                    }
                    catch (LabelNotFoundKernelException e) {
                        throw new IllegalStateException("Not existing label was modified for node " + nodeId, e);
                    }
                }
            }
        });
    }

    @Override
    public void close() {
        this.relationship.close();
    }

    private void addLabelEntriesTo(long nodeId, LongSet labelIds, HeapTrackingArrayList<LabelEntry> target) {
        labelIds.each((LongProcedure & Serializable)labelId -> {
            try {
                target.add((Object)this.createLabelView(this.memoryTracker, this.transaction.tokenRead(), nodeId, labelId));
            }
            catch (LabelNotFoundKernelException e) {
                throw new IllegalStateException("Not existing label was modified for node " + nodeId, e);
            }
        });
    }

    private static RelationshipPropertyEntryView createRelationshipPropertyEntryView(MemoryTracker memoryTracker, TokenRead tokenRead, Relationship relationship, int key, Value newValue, Value oldValue) throws PropertyKeyIdNotFoundKernelException {
        RelationshipPropertyEntryView entryView = new RelationshipPropertyEntryView(relationship, tokenRead.propertyKeyName(key), newValue, oldValue);
        memoryTracker.allocateHeap(RelationshipPropertyEntryView.SHALLOW_SIZE);
        if (oldValue != null) {
            memoryTracker.allocateHeap(oldValue.estimatedHeapUsage());
        }
        return entryView;
    }

    private NodePropertyEntryView createNodePropertyEntryView(MemoryTracker memoryTracker, TokenRead tokenRead, long nodeId, int key, Value newValue, Value oldValue) throws PropertyKeyIdNotFoundKernelException {
        memoryTracker.allocateHeap(NodePropertyEntryView.SHALLOW_SIZE);
        NodePropertyEntryView entryView = new NodePropertyEntryView(this.internalTransaction, nodeId, tokenRead.propertyKeyName(key), newValue, oldValue);
        if (oldValue != null) {
            memoryTracker.allocateHeap(oldValue.estimatedHeapUsage());
        }
        return entryView;
    }

    private LabelEntryView createLabelView(MemoryTracker memoryTracker, TokenRead tokenRead, long nodeId, long labelId) throws LabelNotFoundKernelException {
        memoryTracker.allocateHeap(LabelEntryView.SHALLOW_SIZE);
        return new LabelEntryView(this.internalTransaction, nodeId, tokenRead.nodeLabelName(Math.toIntExact(labelId)));
    }

    private Relationship relationship(long relId) {
        RelationshipEntity relationship = (RelationshipEntity)this.internalTransaction.newRelationshipEntity(relId);
        if (!this.state.relationshipVisit(relId, (RelationshipVisitor)relationship)) {
            RelationshipEntity cached = (RelationshipEntity)this.relationshipsReadFromStore.get(relId);
            if (cached != null) {
                return cached;
            }
            this.relationship.single(relId);
            if (!this.relationship.next()) {
                throw new IllegalStateException("Getting deleted relationship data should have been covered by the tx state");
            }
            relationship.visit(relId, this.relationship.type(), this.relationship.sourceNodeReference(), this.relationship.targetNodeReference());
            this.memoryTracker.allocateHeap(RelationshipEntity.SHALLOW_SIZE);
            this.relationshipsReadFromStore.put(relId, (Object)relationship);
        }
        return relationship;
    }

    private Iterable<Node> map2Nodes(LongIterable ids) {
        return ids.asLazy().collect((LongToObjectFunction & Serializable)id -> new NodeEntity(this.internalTransaction, id));
    }

    private Iterable<Relationship> map2Rels(LongIterable ids) {
        return ids.asLazy().collect(this::relationship);
    }

    private Value committedValue(NodeState nodeState, int property, StorageNodeCursor node, StoragePropertyCursor properties) {
        if (this.state.nodeIsAddedInThisTx(nodeState.getId())) {
            return Values.NO_VALUE;
        }
        node.single(nodeState.getId());
        if (!node.next()) {
            return Values.NO_VALUE;
        }
        return TxStateTransactionDataSnapshot.committedValue(properties, (StorageEntityCursor)node, property, node.entityReference());
    }

    private static Value committedValue(StoragePropertyCursor properties, StorageEntityCursor cursor, int propertyKey, long ownerReference) {
        cursor.properties(properties, PropertySelection.selection((int[])new int[]{propertyKey}));
        return properties.next() ? properties.propertyValue() : Values.NO_VALUE;
    }

    private Value committedValue(RelationshipState relState, int property, StorageRelationshipScanCursor relationship, StoragePropertyCursor properties) {
        if (this.state.relationshipIsAddedInThisTx(relState.getId())) {
            return Values.NO_VALUE;
        }
        relationship.single(relState.getId());
        if (!relationship.next()) {
            return Values.NO_VALUE;
        }
        return TxStateTransactionDataSnapshot.committedValue(properties, (StorageEntityCursor)relationship, property, relationship.entityReference());
    }
}

